/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.ArrayInstruction;
import serp.bytecode.Code;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class ArrayStoreInstruction
extends ArrayInstruction {
    private static final Class[][] _mappings = new Class[][]{{Boolean.TYPE, Integer.TYPE}, {Void.TYPE, Integer.TYPE}};
    static /* synthetic */ Class class$java$lang$Object;

    ArrayStoreInstruction(Code code) {
        super(code);
    }

    ArrayStoreInstruction(Code code, int n) {
        super(code, n);
    }

    public int getLogicalStackChange() {
        switch (this.getOpcode()) {
            case 0: {
                return 0;
            }
        }
        return -3;
    }

    public int getStackChange() {
        switch (this.getOpcode()) {
            case 80: 
            case 82: {
                return -4;
            }
            case 0: {
                return 0;
            }
        }
        return -3;
    }

    public String getTypeName() {
        switch (this.getOpcode()) {
            case 79: {
                return Integer.TYPE.getName();
            }
            case 80: {
                return Long.TYPE.getName();
            }
            case 81: {
                return Float.TYPE.getName();
            }
            case 82: {
                return Double.TYPE.getName();
            }
            case 83: {
                return (class$java$lang$Object == null ? (class$java$lang$Object = ArrayStoreInstruction.class$("java.lang.Object")) : class$java$lang$Object).getName();
            }
            case 84: {
                return Byte.TYPE.getName();
            }
            case 85: {
                return Character.TYPE.getName();
            }
            case 86: {
                return Short.TYPE.getName();
            }
        }
        return null;
    }

    public TypedInstruction setType(String string) {
        if ((string = this.mapType(string, _mappings, true)) == null) {
            return (TypedInstruction)this.setOpcode(0);
        }
        switch (string.charAt(0)) {
            case 'i': {
                return (TypedInstruction)this.setOpcode(79);
            }
            case 'l': {
                return (TypedInstruction)this.setOpcode(80);
            }
            case 'f': {
                return (TypedInstruction)this.setOpcode(81);
            }
            case 'd': {
                return (TypedInstruction)this.setOpcode(82);
            }
            case 'b': {
                return (TypedInstruction)this.setOpcode(84);
            }
            case 'c': {
                return (TypedInstruction)this.setOpcode(85);
            }
            case 's': {
                return (TypedInstruction)this.setOpcode(86);
            }
        }
        return (TypedInstruction)this.setOpcode(83);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterArrayStoreInstruction(this);
        bCVisitor.exitArrayStoreInstruction(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

