package enforcer.rt;

/* $Id: TestWrapper.java 580 2007-05-30 03:07:12Z cartho $ */

import enforcer.log.Log;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.extensions.TestDecorator;

public class TestWrapper extends TestDecorator {
    int i = -1;
    int pathNo = -1;
    String testCls;
    String testMeth;

    public TestWrapper(Test test, String testClass, String testMethod,
                       int n, int p) {
        this(test, testClass, testMethod);
        i = n;
        pathNo = p;
    }

    public TestWrapper(Test test, String testClass, String testMethod) {
        super(test);
        testCls = testClass;
        testMeth = testMethod;
    }

    public void basicRun(TestResult result) {
        Eval.reRun = i;
        Eval.excPath = pathNo;
        assert (testCls != null);
        assert (testMeth != null);
        Log.log(((i != -1) ? "Rer" : "R") + "unning test " + testCls +
                "." + testMeth + "...", Log.DETAILED_INFO);
        Eval.currentTestCls = testCls;
        Eval.currentTestMeth = testMeth;
        fTest.run(result);
    }

    public void run(TestResult result) {
        basicRun(result);
    }
}
