package enforcer.rt;

/* $Id: Coverage.java 580 2007-05-30 03:07:12Z cartho $ */

import enforcer.log.Log;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import junit.framework.Test;

public class Coverage {

    /** Test case class which executes try block but not catch. */
    public static ArrayList<String> noexcCls;

    /** Test case method which executes try block but not catch. */
    public static ArrayList<String> noexcMeth;

    /** Coverage flag to measure whether catch block has been reached. */
    public static BitSet exc = new BitSet();
    // initalize in static initializer because triggered exceptions
    // record their entry directory into the bit set. Such records
    // (coverage) can therefore be used, even if generated by code
    // running before the test suite proper.

    /** Coverage flag to measure calls where no exception is thrown.
      * Note: Should only be counted when no checked method call has
      * been recorded for the same method call. */
    public static BitSet unChecked = new BitSet();

    /** Only record first test for each block in order to avoid
        reflection API calls. */
    /* TODO: Remove code using flag "recorded" as reflection is now
     * avoided. Instead, record faster/better test case when two tests
     * are eligible. */
    public static BitSet recorded = new BitSet();

    /** One path number for each nested try/catch/try block. Note:
    For unlimited nesting, this would have to be a less efficient
    array of sets. */
    public static ArrayList<Integer> excPath;

    /** The number of the highest block that has been executed.
    Method <tt>initialize()</tt> should be called by instrumented
    <tt>main</tt> method. */
    static int numBlocks = -1;

    /** Call this method before running tests. */
    public static void initialize() {
        noexcCls = new ArrayList<String>();
        noexcMeth = new ArrayList<String>();
        excPath = new ArrayList<Integer>();
        numBlocks = 0;
    }

    static void ensureCapacity(ArrayList<? extends Object> l, int n, int size) {
        while (size++ <= n) {
            l.add(null);
        }
        // last element will be overwritten, but this simplifies the code
    }

    static void ensureCapacityInt(ArrayList<Integer> l, int n, int size) {
        while (size++ <= n) {
            l.add(-1);
        }
        // last element will be overwritten, but this simplifies the code
    }

    /** Records coverage information for exception block N.
        Specificially, it records that the end of a <tt>try</tt>
    block has been reached for test case n, and which unit test
    was running. */
    public static void recordTest(int n) {
        if ((numBlocks == -1) || (recorded.get(n))) {
            // (a) initialize() has not been called yet:
            // test setup code still executing, do not record coverage
            // (b) (some) test has already been recorded
            return;
        }
        // Note: n is a "parameter" set at
        // instrumentation time. It will be used as an argument to
        // this method, instrumented as follows:
        // enforcer.rt.Coverage.recordTest(_N_);
        String mth;
        int i, j;
        int size;
        assert (Eval.currentTestCls != null);
        assert (Eval.currentTestMeth != null);
        size = noexcMeth.size();

        ensureCapacity(noexcMeth, n, size);
        noexcMeth.set(n, Eval.currentTestMeth);
        ensureCapacity(noexcCls, n, size);
        noexcCls.set(n, Eval.currentTestCls);
        // Record test re-run number in order to allow for nested
        // exceptions.
        // If tests are running for the first time, then this number
        // will be set to -1, which corresponds to no nesting.
        ensureCapacityInt(excPath, n, size);
        Log.log("Recording test " + Eval.currentTestCls + "." +
                Eval.currentTestMeth +
                " for method call " + n, Log.DEBUG);
        excPath.set(n, Eval.reRun);
        recorded.set(n);
        Eval.newTests = true;

        if (numBlocks <= n) {
            numBlocks = n + 1;
        }
    }
}
