package enforcer.log;

/* $Id: Log.java 580 2007-05-30 03:07:12Z cartho $ */

import enforcer.etc.Options;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class Log {
    public static final int DEBUG_LOWLEVEL = 5;
    public static final int DEBUG = 4;
    public static final int DETAILED_INFO = 3;
    public static final int INFO = 2;
    public static final int WARNING = 1;
    public static final int ERROR = 0;

    public static void log(String msg) {
        log(msg, DEBUG_LOWLEVEL);
    }

    public static void log(String msg, int l) {
        PrintWriter w = (PrintWriter)Options.get("log");
        assert(w != null);
        if (Options.getInt("logLevel") >= l) {
            w.println(msg);
        }
    }

    public static void errLog(String msg) {
        PrintWriter w = (PrintWriter)Options.get("errLog");
        assert(w != null);
        w.println(msg);
    }
}
