package enforcer.instr;

/* $Id: TestUncaughtExc.java 580 2007-05-30 03:07:12Z cartho $ */

import java.io.IOException;
import java.net.ServerSocket;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestUncaughtExc extends TestCase {
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public static Test suite() {
        return new TestSuite(TestUncaughtExc.class);
    }

    public void testReThrow() throws IOException {
        try {
            new ServerSocket();
        } catch (IOException e) {
            throw e; // simulates re-throwing more complex exception
        }
    }

    public void testReThrow2() throws IOException {
        try {
            new ServerSocket();
        } catch (IOException e) {
            e.printStackTrace();
            throw e; // simulates re-throwing more complex exception
        }
    }

    public void testGenuine() throws IOException {
        try {
            new ServerSocket();
        } catch (IOException e) {
            throw new NullPointerException("This is a simulation of a secondary, 'genuine' exception.\n\tA stack trace is supposed to show up in unit test 'testGenuine'.");
        }
    }
}
