package enforcer.instr;

/* $Id: TestTwoCatch.java 580 2007-05-30 03:07:12Z cartho $ */
/* Test two consecutive (non-nested) catch blocks.
   (1) Instrumentation could be optimized: end of try block only
       has to be instrumented once.
   (2) Instrumentation for second try/catch block (with same try
       range) should not interfere with first one, even if optimization
       is not present. */

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTwoCatch extends TestCase {
    static int n = 0;

    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public static Test suite() {
        return new TestSuite(TestTwoCatch.class);
    }

    private void thisIsDangerous() throws NullPointerException {}

    public void testTwoCatch() {
        int i = 0;
        try {
            thisIsDangerous();
        } catch (NullPointerException e) {
            i = 1;
        } catch (Exception e) {
            i = 2;
        }
assert(i == n) : "i != n : " + i + " != " + n;
        n++;
    }
}
