package enforcer.instr;

/* $Id: TestMany.java 580 2007-05-30 03:07:12Z cartho $ */
/* Test run-time overhead by having an exception block inside a
   loop, and a loop inside an exception block. */

//import java.text.NumberFormat;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMany extends TestCase {
    final static int N = 10000;

    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public static Test suite() {
        return new TestSuite(TestMany.class);
    }

    public int assign(int i) throws Exception {
        return i;
    }

    public void testMany1() {
        int i = 0;
        //long startTime= System.currentTimeMillis();
        for (int j = 0; j < N; j++) {
            try {
                i = assign(1);
            } catch (Exception e) {
                i = 2;
            }
        }
        //long endTime= System.currentTimeMillis();
        //long runTime= endTime-startTime;
        //System.out.println("testMany1: " + NumberFormat.getInstance().format((double)runTime/1000) + " s");
    }

    public void testMany2() {
        int i = 0;
        try {
            for (int j = 0; j < N; j++) {
                i = assign(1);
            }
        } catch (Exception e) {
            i = 2;
        }
    }

    public void testMany3() {
        int i = 0;
        try {
            i = assign(1);
        } catch (Exception e) {
            for (int j = 0; j < N; j++) {
                i = 2;
            }
        }
    }
}
