package enforcer.etc;

/* $Id: Options.java 580 2007-05-30 03:07:12Z cartho $ */

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;

public class Options {
    public static HashMap<String, Object> options =
        new HashMap<String, Object>();

    static boolean getBooleanFromEnv(String optName) throws Exception {
        String envValue = System.getenv(optName);
        if ((envValue.equals("1")) || (envValue.equals("yes")) ||
                (envValue.equals("true"))) {
            return true;
        }
        return false;
    }

    static void setBoolOpt(String optName, String envName, boolean opt) {
        try {
            opt = getBooleanFromEnv(envName);
        } catch (Exception e) {}
        options.put(optName, new Boolean(opt));
    }

    static {
        String instrEnv;
        String log;
        String dumpPath = null;
        int logLevel = 2;
        boolean instrTestCode = false;
        boolean dynExcCheck = false;
        boolean supprArtificialExc = true;
        options.put("log", new PrintWriter (System.out, true));
        options.put("errLog", new PrintWriter (System.err, true));
        try {
            dumpPath = System.getenv("ENFORCER_INSTR_DUMP");
            log = System.getenv("ENFORCER_LOGLEVEL");
            logLevel = (new Integer(log)).intValue();
        } catch (Exception e) {}
        options.put("dumpPath", dumpPath);
        setBoolOpt("instrTestCode", "ENFORCER_INSTR_TESTCODE", instrTestCode);
        setBoolOpt("dynExcCheck", "ENFORCER_DYN_EXC_CHECK", dynExcCheck);
        setBoolOpt("supprArtificialExc", "ENFORCER_SUPPR_ARTIF_EXC",
                   supprArtificialExc);
        options.put("logLevel", new Integer(logLevel));
    }

    /** Override setting of environment variable. */
    public static void set
        (String key, Object data) {
        options.put(key, data);
    }

    /** Set option with string value as data. */
    public static void setString(String key, String data) {
        set
            (key, data);
    }

    /** Set option with boolean value as data. */
    public static void setBool(String key, boolean data) {
        set
            (key, new Boolean(data));
    }

    /** Set option with int value as data. */
    public static void setInt(String key, Integer data) {
        set
            (key, new Integer(data));
    }

    /** Query option. Result needs to be type cast. */
    public static Object get
        (String key) {
        return options.get(key);
    }

    /** Query string option. */
    public static String getString(String key) {
        return (String)options.get(key);
    }

    /** Query boolean option. */
    public static boolean getBool(String key) {
        Boolean res = (Boolean)options.get(key);
        return res.booleanValue();
    }

    /** Query integer option. */
    public static int getInt(String key) {
        Integer res = (Integer)options.get(key);
        return res.intValue();
    }

    /** Key set, for CLI. */
    public static Set<String> keySet() {
        return options.keySet();
    }
}
