/* $Id$ */
/* Example program to be tested by TestExample. */

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class Example {
    public static void twiddleTempFile() {
	try {
	    File tempFile = File.createTempFile("enforcer", "");
	    // (1) IOException may occur
	    assert (tempFile.canRead());
	    assert (tempFile.canWrite());
	    FileOutputStream out = new FileOutputStream(tempFile);
	    // (2) FileNotFoundException may occur
	    out.write(new String("Test").getBytes());
	    // (3) IOException may occur
	    out.close();
	    // (4) IOException may occur
	    tempFile.delete();
	} catch (FileNotFoundException e) {
	    System.err.println("Cannot access temp. file.");
	    e.printStackTrace();
	} catch (IOException e) {
	    System.err.println("Cannot create, write, or close temp. file.");
	    e.printStackTrace();
	}
    }

    public static final void main(String[] args) {
	twiddleTempFile();
    }
}
