/* $Id: WrappedRunner.java 580 2007-05-30 03:07:12Z cartho $ */

package enforcer.rt;

/** Wraps each test in the initial test suite.
    Each Test is encapsulated in a wrapper such that it is properly
    registered. */

import enforcer.log.Log;
import enforcer.rt.Eval;
import enforcer.rt.TestWrapper;
import java.lang.reflect.Method;
import java.util.Enumeration;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class WrappedRunner {
    static Method runMethod;

    public static void handleException(Exception exc, Class runner) {
        if (runner == null) {
            Log.errLog("Cannot find test runner: " + exc);
        } else {
            Log.errLog("Cannot execute test runner " +
                       runner.getName() + ".run: " + exc);
            exc.printStackTrace();
        }
    }

    /** Replaces junit.X.run. @param test = original parameter to run. */
    public static TestResult run(Test test) {
        TestSuite formerSuite, newSuite;
        Class runner = null;
        try {
            runner = Class.forName(Eval.testRunner);
            runMethod = runner.getMethod("run", Test.class);
            formerSuite = new TestSuite();
            formerSuite.addTest(test);
            newSuite = wrapTests(formerSuite);
            return (TestResult) runMethod.invoke(null, newSuite);
        } catch (Exception exc) {
            handleException(exc, runner);
            return null;
        }
    }

    /** Replaces junit.X.run. @param test = original parameter to run. */
    public static void run(Class test) {
        TestSuite formerSuite, newSuite;
        Class runner = null;
        try {
            runner = Class.forName(Eval.testRunner);
            runMethod = runner.getMethod("run", Test.class);
            formerSuite = new TestSuite();
            formerSuite.addTestSuite((Class) test);
            newSuite = wrapTests(formerSuite);
            runMethod.invoke(null, newSuite);
        } catch (Exception exc) {
            handleException(exc, runner);
        }
    }

    /** Wraps each test. */
    public static TestSuite wrapTests(TestSuite formerSuite) {
        TestSuite newSuite = new TestSuite();
        // iterate through test suite (if any)
        Enumeration tests = formerSuite.tests();
        while (tests.hasMoreElements()) {
            // wrap each test
            Test testObj = (Test) tests.nextElement();
            if (testObj instanceof TestSuite) {
                TestSuite testSuite = (TestSuite) testObj;
                newSuite.addTest(WrappedRunner.wrapTests(testSuite));
            } else {
                TestCase testCase = (TestCase) testObj;
                newSuite.addTest(new TestWrapper(testCase,
                                                 testCase.getClass().getName(),
                                                 testCase.getName()));
            }
        }
        return newSuite;
    }
}
