package enforcer.rt;

/* $Id: Eval.java 580 2007-05-30 03:07:12Z cartho $ */

import enforcer.etc.Options;
import enforcer.log.Log;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.BitSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class Eval {
    static boolean dynExcCheck = Options.getBool("dynExcCheck");

    public static String testRunner = "junit.textui.TestRunner";
    /** Index of exception block trying to be reached when re-running
    tests. */
    public static int reRun = -1;

    /** Index of reRun when reaching nested exception. */
    public static int excPath = -1;

    /** Records whether new tests have been recorded since the start
    of the current run. */
    static boolean newTests;

    /** Current test which is being executed (in order to avoid
        reification of current test from stack trace). */
    static String currentTestMeth;
    static String currentTestCls;

    /** Overrides textui TestRunner (used by instrumentation) */
    public static void setTestRunner(String runner) {
        testRunner = runner;
    }

    int suiteSize = 0;
    int numCatch = 0;
    int numTry = 0;
    int numUnChecked = 0;

    static TestCase getTestInstance(Class cls) throws
                NoSuchMethodException, InstantiationException,
                IllegalAccessException, IllegalArgumentException,
        InvocationTargetException {
        Constructor cons;
        Class[] args = { String.class };
        try {
            cons = cls.getConstructor(args);
            return (TestCase) cons.newInstance(cls.getSimpleName());
        } catch (NoSuchMethodException e) {
            // other try below: constructor without arguments
        }
        cons = cls.getConstructor(new Class[0]);
        return (TestCase) cons.newInstance();
    }

    void getStats(TestSuite suite) {
        TestCase testCase;
        int end;
        int i;
        end = Coverage.numBlocks;
        for (i = 0; i < end; i++) {
            // check each instr. cov. point
            String cls;
            if (!Coverage.exc.get(i)) { // exc. untested, re-run test
                // If the last exception has not been triggered, there is
                // no corresponding array entry; thus check for actually
                // recorded index.
                if ((Coverage.noexcCls.size() <= i) ||
                        ((cls = Coverage.noexcCls.get(i)) == null)) {
                    // nested exception: end of try block never reached
                    // check whether exc. could not be thrown by given type
                    if (dynExcCheck && Coverage.unChecked.get(i)) {
                        numUnChecked++;
                        numTry++;
                    }
                    continue;
                }
                numTry++;
                testCase = null;
                try {
                    Class test = Class.forName(cls);
                    testCase = getTestInstance(test);
                } catch (Exception exc) {
                    // cannot execute test
                    Log.errLog("Cannot find class for test " + i +
                               ": " + cls + ": " + exc);
                    continue;
                }
                suiteSize++;
                if (suite != null) {
                    String meth = Coverage.noexcMeth.get(i);
                    Log.log("Adding test for method call " + i + " in " +
                            cls + "." + meth, Log.DEBUG);
                    testCase.setName(Coverage.noexcMeth.get(i));
                    suite.addTest(new TestWrapper(testCase, cls, meth, i,
                                                  Coverage.excPath.get(i)));
                }
                // test wrapper sets reRun index prior to test run
            } else {
                numCatch++;
                numTry++;
            }
        }
    }

    /** Re-runs all tests; may have to be called multiple times.
    Tests which are only reachable when nested exceptions are
    forced can only be run in a subsequent iteration.
    @return true if done (no re-run necessary).  */
    public static boolean reRunTests() {
        TestSuite suite = new TestSuite(); // for re-running tests
        Eval eval = new Eval();
        Log.log("*** Total number of instrumented method calls: " +
                enforcer.instr.CoverageTransformer.excBlock, Log.INFO);
        newTests = false;
        eval.getStats(suite);
        Log.log("*** Total number of executed method calls: " +
                eval.numTry, Log.INFO);
        Log.log("*** Total number of executed catch blocks: " +
                eval.numCatch, Log.INFO);
        if (dynExcCheck) {
            Log.log("*** Total number of executed method calls w/o exc.: " +
                    eval.numUnChecked, Log.INFO);
        }
        Log.log("*** Tests with uncovered catch blocks to execute: " +
                eval.suiteSize, Log.INFO);
        if (eval.suiteSize == 0) {
            return true;
        }
        try {
            Class testRunClass = Class.forName(testRunner);
            Method testRunMethod =
                testRunClass.getMethod("run", Test.class);
            testRunMethod.invoke(testRunClass, suite);
        } catch (Exception exc) {
            Log.errLog("Could not start test runner " + testRunner + ".");
        }
        // if instrumentation is no longer effective (e.g. unreachable
        // end of try block, abort
        if (!newTests) {
            eval = new Eval();
            eval.getStats(null);
            Log.log("*** Total number of executed method calls: " +
                    eval.numTry, Log.INFO);
            Log.log("*** Total number of executed catch blocks: " +
                    eval.numCatch, Log.INFO);
            if (dynExcCheck) {
                Log.log("*** Total number of executed method calls " +
                        "w/o exc.: " + eval.numUnChecked, Log.INFO);
            }
            Log.log("*** Tests with uncovered catch blocks to execute: " +
                    eval.suiteSize, Log.INFO);
        }
        return !newTests;
    }
}
