package enforcer.instr;

/* $Id: TestUnreachableEndOfTry.java 580 2007-05-30 03:07:12Z cartho $ */
/* Test class where end of try block is unreachable */

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestUnreachableEndOfTry extends TestCase {

    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public static Test suite() {
        return new TestSuite(TestUnreachableEndOfTry.class);
    }

    public int assign(int i) throws Exception {
        return i;
    }

    public void testReachableEndOfTry() {
        int i = 0;
        try {
            i = assign(1);
        } catch (Exception e) {
            i = 2;
        }
    }

    public void testNested() {
        int i = 0;
        try {
            i = assign(1);
            try {
                i = assign(2);
            } catch (Exception e0) {
                i = 3;
            }
        } catch (Exception e1) {
            try {
                i = assign(4);
            } catch (Exception e2) {
                i = 5;
            }
        }
        //System.out.println("---> " + i);
    }

    public void testUnreachableEndOfTry() {
        int i = 0;
        while (i < 2) {
            if (i == 0)
                break;
            try {
                i = assign(++i);
            } catch (Exception e) {
                i--;
            }
        }
    }
}
