package enforcer.instr;

/* $Id: TestNestedExcSubType2.java 580 2007-05-30 03:07:12Z cartho $ */
/* Nested exceptions with sub type inside */
/* Two problems:
   (1) Nested exception has to take priority to outer exc. if subtype.
   (2) Invocation may not throw super type. */

import enforcer.rt.Coverage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestNestedExcSubType2 extends TestCase {
    private static int res = 2;

    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public static Test suite() {
        return new TestSuite(TestNestedExcSubType2.class);
    }

    int assign(int i) throws Exception {
        return i;
    }

    int assignN(int i) throws NullPointerException {
        return i;
    }

    public void testForceExc() { // exception that does not occur
        int i = 0;
        try {
            i = assignN(1);
            try {
                i = assignN(2);
            } catch (NullPointerException e0) {
                i = 3;
            }
        } catch (Exception e1) {
            i = 4;
        }
        //assert ((i == res) || (i == 4)) : "i != res : " + i + " != " + res;
        res += 2;
        if (res == 6) {
            res = 3;
        }
        // final values of i: 2 (uninstr.), 4 (outer exc.), 3 (inner exc.)
        //System.out.println("---> " + i);
    }
}
