package enforcer.instr;

/* $Id: TestInterface.java 580 2007-05-30 03:07:12Z cartho $ */
/* Only instances where implementation possibly throws exception
   should be counted. */

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

class IFace2 implements Interface_Super {
    public void doSth() throws Exception {}
}

class IFaceNoExc implements Interface_Super {
    public void doSth() {}
}

public class TestInterface extends TestCase implements Test_Interface {
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public static Test suite() {
        return new TestSuite(TestInterface.class);
    }

    public void doSth() {}

    private void helper(Interface_Super obj) {
        try {
            obj.doSth();
        } catch (Exception e) {}
    }

    // test one call where type throws exc., another one where this
    // is not the case
    public void testDual() {
        Interface_Super iface2 = new IFace2();
        Interface_Super ifaceNoExc = new IFaceNoExc();
        helper(ifaceNoExc); // no exception
        helper(iface2); // throws exception
    }

    public void testInterface() {
        try {
            Test_Interface iface = new TestInterface();
            Interface_Super iface2 = new IFace2();
            Interface_Super ifaceNoExc = new IFaceNoExc();
            new TestInterface().doSth();
            // implementing class does NOT throw exception
            iface.doSth();
            // implementing interface does NOT throw exception
            iface2.doSth();
            // one exception instrumented (interface decl's exception)
            ifaceNoExc.doSth();
            // does not throw exception; needs run-time check
        } catch (Exception e) {}
    }
}
