package enforcer.rt;

/* $Id: TestReflect.java 580 2007-05-30 03:07:12Z cartho $ */

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestReflect extends TestCase {
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public static Test suite() {
        return new TestSuite(TestReflect.class);
    }

    public void testArray() {
        Integer[] integerArray = new Integer[0];
        Integer[][] integerArray2 = new Integer[0][0];
        int[] intArray = new int[0];
        int[][] intArray2 = new int[0][0];
        assertEquals (integerArray.getClass(),
                      Reflect.getClsDesc("[Ljava/lang/Integer;"));
        assertEquals (integerArray2.getClass(),
                      Reflect.getClsDesc("[[Ljava/lang/Integer;"));
        assertEquals (intArray.getClass(), Reflect.getClsDesc("[I"));
        assertEquals (intArray2.getClass(), Reflect.getClsDesc("[[I"));
    }

    public void testFull() {
        assertEquals (String.class, Reflect.getClsDesc("Ljava/lang/String;"));
        assertEquals (Integer.class, Reflect.getClsDesc("Ljava/lang/Integer;"));
        assertEquals (Class.class, Reflect.getClsDesc("Ljava/lang/Class;"));
        assertEquals (null, Reflect.getClsDesc("L/;"));
    }

    public void testPrim() {
        assertEquals (byte.class, Reflect.getClsDesc("B"));
        assertEquals (byte.class, Reflect.getClsDesc("byte"));
        assertEquals (char.class, Reflect.getClsDesc("C"));
        assertEquals (char.class, Reflect.getClsDesc("char"));
        assertEquals (double.class, Reflect.getClsDesc("D"));
        assertEquals (double.class, Reflect.getClsDesc("double"));
        assertEquals (float.class, Reflect.getClsDesc("F"));
        assertEquals (float.class, Reflect.getClsDesc("float"));
        assertEquals (int.class, Reflect.getClsDesc("I"));
        assertEquals (int.class, Reflect.getClsDesc("int"));
        assertEquals (long.class, Reflect.getClsDesc("J"));
        assertEquals (long.class, Reflect.getClsDesc("long"));
        assertEquals (short.class, Reflect.getClsDesc("S"));
        assertEquals (short.class, Reflect.getClsDesc("short"));
        assertEquals (boolean.class, Reflect.getClsDesc("Z"));
        assertEquals (boolean.class, Reflect.getClsDesc("boolean"));
    }
}
