package enforcer.rt;

/* $Id: TestEval.java 580 2007-05-30 03:07:12Z cartho $ */

import enforcer.log.Log;
import enforcer.etc.Options;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestEval extends TestCase {
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public static Test suite() {
        return new TestSuite(TestEval.class);
    }

    public void testEval() {
        OutputStream ostr;
        PrintWriter pw;
        Coverage.initialize();
        // entry 1 is never set (== null)
        Eval.setTestRunner(null);
        // set up log file (manually, since JUnit does not support this)
        try {
            ostr = new FileOutputStream("enforcer/log/rt/testEval.err");
        } catch (FileNotFoundException e) {
            ostr = System.err;
        }
        pw = new PrintWriter(ostr, true);
        Options.set("errLog", pw);
        // actual test
        Eval.reRunTests();
        // close log
        if (ostr != System.err) {
            try {
                ostr.close();
            } catch (IOException e) {
                System.err.println("Could not close error log!");
            }
        }
    }
}
