package enforcer.rt;

/* $Id: ExceptionTestCase.java 580 2007-05-30 03:07:12Z cartho $ */

import enforcer.etc.Options;
import enforcer.instr.CoverageTransformer;
import enforcer.log.Log;
import junit.framework.TestCase;

/** See junit.extensions.ExceptionTestCase for explanations. */

public class ExceptionTestCase extends TestCase {
    static boolean keepArtificialException =
        !(Options.getBool("supprArtificialExc"));

    public ExceptionTestCase() {
        super();
    }

    public ExceptionTestCase(String str) {
        super(str);
    }

    public void runTest() throws Throwable {
        try {
            super.runTest();
        } catch (Exception e) {
            if (keepArtificialException) {
                throw e;
            }
            String msg;
            msg = e.getMessage();
            if ((msg == null) ||
                    !(msg.equals(CoverageTransformer.ENFORCER_EXC_MSG))) {
                throw e; // rethrow exception
            } else {
                Log.log("Filtered " + e.getClass().getName(), Log.DEBUG);
            }
        }
    }
}
