package enforcer.instr;

/* $Id: TestCoverageTransformer.java 584 2010-02-15 05:55:18Z cartho $ */

import enforcer.etc.Options;
import enforcer.log.Log;
import enforcer.rt.Coverage;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import serp.bytecode.Project;

public class TestCoverageTransformer extends TestCase {
    final static HelperClass helper = new HelperClass();
    private boolean instr = true;

    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public static Test suite() {
        return new TestSuite(TestCoverageTransformer.class);
    }

    void exc() throws Exception {
	instr = false;
        throw new Exception();
    }

    public void testHandlerCoverage() { // "works" only if instr. active
        try {
            exc();
        } catch (Exception e) {
            assert(!instr || Coverage.exc.get(0));
        }
    }

    public void testInstrumentation() {
        int blk = CoverageTransformer.excBlock;
        CoverageTransformer t = new CoverageTransformer();
        Options.setBool("instrTestCode", true);
        byte[] result = t.transform(new Project().loadClass(getClass()));
        try {
            FileOutputStream f =
                new FileOutputStream("enforcer/log/instr/" +
                                     "TestCoverageTransformer.class");
            f.write(result);
            f.close();
        } catch (java.io.IOException e) {
            Log.log("Could not open file: " + e, Log.DEBUG);
        }
        CoverageTransformer.excBlock = blk;
    }

    public void testDump() {
        int blk = CoverageTransformer.excBlock;
        CoverageTransformer t = new CoverageTransformer();
        String oldOption = Options.getString("dumpPath");
        Options.setString("dumpPath", "enforcer/log/instr");
        t.transform(new Project().loadClass(getClass()));
        CoverageTransformer.excBlock = blk;
        Options.setString("dumpPath", oldOption);
    }

    int inc(int i) throws Exception {
        return ++i;
    }

    public void testForceExc() { // exception that does not occur
        int i = 0;
        try {
            i = inc(i);
        } catch (Exception e) {
            i--;
        }
        assert (i == helper.getRes());
    }
}
