/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import serp.bytecode.ArrayState;
import serp.bytecode.BCClass;
import serp.bytecode.NameCache;
import serp.bytecode.ObjectState;
import serp.bytecode.PrimitiveState;
import serp.bytecode.visitor.BCVisitor;
import serp.bytecode.visitor.VisitAcceptor;
import serp.util.Strings;

public class Project
implements VisitAcceptor {
    private final String _name;
    private final HashMap _cache = new HashMap();
    private final NameCache _names = new NameCache();
    static /* synthetic */ Class class$java$lang$Object;

    public Project() {
        this(null);
    }

    public Project(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public NameCache getNameCache() {
        return this._names;
    }

    public BCClass loadClass(String string) {
        return this.loadClass(string, null);
    }

    public BCClass loadClass(String string, ClassLoader classLoader) {
        BCClass bCClass = this.checkCache(string = this._names.getExternalForm(string, false));
        if (bCClass != null) {
            return bCClass;
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            return this.loadClass(Strings.toClass(string, classLoader));
        }
        catch (Exception exception) {
            String string2 = this._names.getComponentName(string);
            BCClass bCClass2 = new BCClass(this);
            if (string2 != null) {
                bCClass2.setState(new ArrayState(string, string2));
            } else {
                bCClass2.setState(new ObjectState(this._names));
                bCClass2.setName(string);
                bCClass2.setSuperclass(class$java$lang$Object == null ? (class$java$lang$Object = Project.class$("java.lang.Object")) : class$java$lang$Object);
            }
            this.cache(string, bCClass2);
            return bCClass2;
        }
    }

    public BCClass loadClass(Class clazz) {
        BCClass bCClass = this.checkCache(clazz.getName());
        if (bCClass != null) {
            return bCClass;
        }
        BCClass bCClass2 = new BCClass(this);
        if (clazz.isPrimitive()) {
            bCClass2.setState(new PrimitiveState(clazz, this._names));
        } else if (clazz.isArray()) {
            bCClass2.setState(new ArrayState(clazz.getName(), this._names.getExternalForm(clazz.getComponentType().getName(), false)));
        } else {
            bCClass2.setState(new ObjectState(this._names));
            try {
                bCClass2.read(clazz);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
        }
        this.cache(clazz.getName(), bCClass2);
        return bCClass2;
    }

    public BCClass loadClass(File file) {
        BCClass bCClass = new BCClass(this);
        bCClass.setState(new ObjectState(this._names));
        try {
            bCClass.read(file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        String string = bCClass.getName();
        BCClass bCClass2 = this.checkCache(string);
        if (bCClass2 != null) {
            return bCClass2;
        }
        this.cache(string, bCClass);
        return bCClass;
    }

    public BCClass loadClass(InputStream inputStream) {
        BCClass bCClass = new BCClass(this);
        bCClass.setState(new ObjectState(this._names));
        try {
            bCClass.read(inputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        String string = bCClass.getName();
        BCClass bCClass2 = this.checkCache(string);
        if (bCClass2 != null) {
            return bCClass2;
        }
        this.cache(string, bCClass);
        return bCClass;
    }

    public BCClass loadClass(BCClass bCClass) {
        String string = bCClass.getName();
        BCClass bCClass2 = this.checkCache(string);
        if (bCClass2 != null) {
            return bCClass2;
        }
        BCClass bCClass3 = new BCClass(this);
        if (bCClass.isPrimitive()) {
            bCClass3.setState(new PrimitiveState(bCClass.getType(), this._names));
        } else if (bCClass.isArray()) {
            bCClass3.setState(new ArrayState(bCClass.getName(), bCClass.getComponentName()));
        } else {
            bCClass3.setState(new ObjectState(this._names));
            bCClass3.read(bCClass);
        }
        this.cache(string, bCClass3);
        return bCClass3;
    }

    public void clear() {
        Collection collection = this._cache.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BCClass bCClass = (BCClass)iterator.next();
            iterator.remove();
            bCClass.invalidate();
        }
        this._names.clear();
    }

    public boolean removeClass(String string) {
        return this.removeClass(this.checkCache(string));
    }

    public boolean removeClass(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return this.removeClass(this.checkCache(clazz.getName()));
    }

    public boolean removeClass(BCClass bCClass) {
        if (bCClass == null) {
            return false;
        }
        if (!this.removeFromCache(bCClass.getName(), bCClass)) {
            return false;
        }
        bCClass.invalidate();
        return true;
    }

    public BCClass[] getClasses() {
        Collection collection = this._cache.values();
        return collection.toArray(new BCClass[collection.size()]);
    }

    public boolean containsClass(String string) {
        return this._cache.containsKey(string);
    }

    public boolean containsClass(Class clazz) {
        return clazz == null ? false : this.containsClass(clazz.getName());
    }

    public boolean containsClass(BCClass bCClass) {
        return bCClass == null ? false : this.containsClass(bCClass.getName());
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterProject(this);
        BCClass[] bCClassArray = this.getClasses();
        for (int i = 0; i < bCClassArray.length; ++i) {
            bCClassArray[i].acceptVisit(bCVisitor);
        }
        bCVisitor.exitProject(this);
    }

    void renameClass(String string, String string2, BCClass bCClass) {
        if (string.equals(string2)) {
            return;
        }
        BCClass bCClass2 = this.checkCache(string2);
        if (bCClass2 != null) {
            throw new IllegalStateException("A class with name " + string2 + " already exists in this project");
        }
        this.removeFromCache(string, bCClass);
        this.cache(string2, bCClass);
    }

    private BCClass checkCache(String string) {
        return (BCClass)this._cache.get(string);
    }

    private void cache(String string, BCClass bCClass) {
        this._cache.put(string, bCClass);
    }

    private boolean removeFromCache(String string, BCClass bCClass) {
        BCClass bCClass2 = this.checkCache(string);
        if (bCClass2 != bCClass) {
            return false;
        }
        this._cache.remove(string);
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

