/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.BCClass;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.TypedInstruction;
import serp.bytecode.lowlevel.ClassEntry;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.visitor.BCVisitor;
import serp.util.Numbers;

public class ConstantInstruction
extends TypedInstruction {
    private int _arg = -1;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;

    ConstantInstruction(Code code) {
        super(code);
    }

    ConstantInstruction(Code code, int n) {
        super(code, n);
    }

    int getLength() {
        switch (this.getOpcode()) {
            case 16: 
            case 18: {
                return super.getLength() + 1;
            }
            case 17: 
            case 19: 
            case 20: {
                return super.getLength() + 2;
            }
        }
        return super.getLength();
    }

    public int getStackChange() {
        String string = this.getTypeName();
        if (Double.TYPE.getName().equals(string) || Long.TYPE.getName().equals(string)) {
            return 2;
        }
        return 1;
    }

    public int getLogicalStackChange() {
        return 1;
    }

    public String getTypeName() {
        int n = this.getOpcode();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return (class$java$lang$Object == null ? (class$java$lang$Object = ConstantInstruction.class$("java.lang.Object")) : class$java$lang$Object).getName();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                return Integer.TYPE.getName();
            }
            case 9: 
            case 10: {
                return Long.TYPE.getName();
            }
            case 11: 
            case 12: 
            case 13: {
                return Float.TYPE.getName();
            }
            case 14: 
            case 15: {
                return Double.TYPE.getName();
            }
        }
        Entry entry = this.getPool().getEntry(this._arg);
        switch (entry.getType()) {
            case 1: 
            case 8: {
                return (class$java$lang$String == null ? (class$java$lang$String = ConstantInstruction.class$("java.lang.String")) : class$java$lang$String).getName();
            }
            case 3: {
                return Integer.TYPE.getName();
            }
            case 4: {
                return Float.TYPE.getName();
            }
            case 5: {
                return Long.TYPE.getName();
            }
            case 6: {
                return Double.TYPE.getName();
            }
            case 7: {
                return (class$java$lang$Class == null ? (class$java$lang$Class = ConstantInstruction.class$("java.lang.Class")) : class$java$lang$Class).getName();
            }
        }
        return null;
    }

    public TypedInstruction setType(String string) {
        throw new UnsupportedOperationException("Use setValue");
    }

    public Object getValue() {
        int n = this.getOpcode();
        switch (n) {
            case 0: 
            case 1: {
                return null;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Numbers.valueOf(n - 3);
            }
            case 9: 
            case 10: {
                return Numbers.valueOf((long)(n - 9));
            }
            case 11: 
            case 12: 
            case 13: {
                return new Float(n - 11);
            }
            case 14: 
            case 15: {
                return new Double(n - 14);
            }
            case 16: 
            case 17: {
                return Numbers.valueOf(this._arg);
            }
        }
        Entry entry = this.getPool().getEntry(this._arg);
        Object object = ((ConstantEntry)((Object)entry)).getConstant();
        if (entry.getType() == 7) {
            return this.getProject().getNameCache().getExternalForm((String)object, false);
        }
        return object;
    }

    public ConstantInstruction setValue(Object object) {
        if (object instanceof Boolean) {
            object = Numbers.valueOf((Boolean)object != false ? 1 : 0);
        } else if (object instanceof Character) {
            object = Numbers.valueOf(((Character)object).charValue());
        } else if (object instanceof Byte) {
            object = Numbers.valueOf(((Byte)object).intValue());
        } else if (object instanceof Short) {
            object = Numbers.valueOf(((Short)object).intValue());
        } else if (!(object == null || object instanceof Number || object instanceof String || object instanceof Class || object instanceof BCClass)) {
            throw new IllegalArgumentException("value = " + object);
        }
        this.calculateOpcode(object, false);
        return this;
    }

    public String getStringValue() {
        return (String)this.getValue();
    }

    public int getIntValue() {
        Object object = this.getValue();
        return object == null ? 0 : ((Number)object).intValue();
    }

    public long getLongValue() {
        Object object = this.getValue();
        return object == null ? 0L : ((Number)object).longValue();
    }

    public float getFloatValue() {
        Object object = this.getValue();
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    public double getDoubleValue() {
        Object object = this.getValue();
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    public String getClassNameValue() {
        return (String)this.getValue();
    }

    public ConstantInstruction setNull() {
        this.calculateOpcode(null, false);
        return this;
    }

    public ConstantInstruction setValue(String string) {
        this.calculateOpcode(string, false);
        return this;
    }

    public ConstantInstruction setValue(Class clazz) {
        this.calculateOpcode(clazz, false);
        return this;
    }

    public ConstantInstruction setValue(BCClass bCClass) {
        this.calculateOpcode(bCClass, false);
        return this;
    }

    public ConstantInstruction setValue(int n) {
        this.calculateOpcode(Numbers.valueOf(n), false);
        return this;
    }

    public ConstantInstruction setValue(long l) {
        this.calculateOpcode(Numbers.valueOf(l), false);
        return this;
    }

    public ConstantInstruction setValue(float f) {
        this.calculateOpcode(new Float(f), false);
        return this;
    }

    public ConstantInstruction setValue(double d) {
        this.calculateOpcode(new Double(d), false);
        return this;
    }

    public ConstantInstruction setValue(boolean bl) {
        return this.setValue(bl ? 1 : 0);
    }

    public ConstantInstruction setValue(short s) {
        return this.setValue((int)s);
    }

    public ConstantInstruction setValue(char c) {
        return this.setValue((int)c);
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (this == instruction) {
            return true;
        }
        if (!(instruction instanceof ConstantInstruction)) {
            return false;
        }
        Object object = this.getValue();
        Object object2 = ((ConstantInstruction)instruction).getValue();
        return object == null || object2 == null || object.equals(object2);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterConstantInstruction(this);
        bCVisitor.exitConstantInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        ConstantInstruction constantInstruction = (ConstantInstruction)instruction;
        this.calculateOpcode(constantInstruction.getValue(), constantInstruction.getOpcode() == 19);
    }

    void read(DataInput dataInput) throws IOException {
        super.read(dataInput);
        switch (this.getOpcode()) {
            case 16: 
            case 18: {
                this._arg = dataInput.readUnsignedByte();
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                this._arg = dataInput.readUnsignedShort();
            }
        }
    }

    void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        switch (this.getOpcode()) {
            case 16: 
            case 18: {
                dataOutput.writeByte(this._arg);
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                dataOutput.writeShort(this._arg);
            }
        }
    }

    private void calculateOpcode(Object object, boolean bl) {
        this._arg = -1;
        if (object == null) {
            this.setOpcode(1);
        } else if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            if (f == 0.0f || f == 1.0f || f == 2.0f) {
                this.setOpcode(11 + (int)f);
            } else {
                this._arg = this.getPool().findFloatEntry(f, true);
                this.setOpcode(this._arg > 255 || bl ? 19 : 18);
            }
        } else if (object instanceof Long) {
            long l = (Long)object;
            if (l == 0L || l == 1L) {
                this.setOpcode(9 + (int)l);
            } else {
                this._arg = this.getPool().findLongEntry(l, true);
                this.setOpcode(20);
            }
        } else if (object instanceof Double) {
            double d = (Double)object;
            if (d == 0.0 || d == 1.0) {
                this.setOpcode(14 + (int)d);
            } else {
                this._arg = this.getPool().findDoubleEntry(d, true);
                this.setOpcode(20);
            }
        } else if (object instanceof Integer) {
            int n = (Integer)object;
            if (n >= -1 && n <= 5) {
                this.setOpcode(3 + n);
            } else if (n >= -128 && n < 128) {
                this.setOpcode(16);
                this._arg = n;
            } else if (n >= Short.MIN_VALUE && n < 32768) {
                this.setOpcode(17);
                this._arg = n;
            } else {
                this._arg = this.getPool().findIntEntry(n, true);
                this.setOpcode(this._arg > 255 || bl ? 19 : 18);
            }
        } else if (object instanceof String) {
            this._arg = this.getPool().findStringEntry((String)object, true);
            this.setOpcode(this._arg > 255 || bl ? 19 : 18);
        } else if (object instanceof Class) {
            String string = this.getProject().getNameCache().getInternalForm(((Class)object).getName(), false);
            this._arg = this.getPool().findClassEntry(string, true);
            this.setOpcode(19);
        } else if (object instanceof BCClass) {
            BCClass bCClass = (BCClass)object;
            ClassEntry classEntry = (ClassEntry)bCClass.getPool().getEntry(bCClass.getIndex());
            this._arg = bCClass.getPool() == this.getPool() ? this.getPool().indexOf(classEntry) : this.getPool().findClassEntry((String)classEntry.getConstant(), true);
            this.setOpcode(19);
        } else {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

