/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import serp.bytecode.Attribute;
import serp.bytecode.Attributes;
import serp.bytecode.BCClass;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtr;
import serp.bytecode.LocalVariable;
import serp.bytecode.visitor.BCVisitor;

public class LocalVariableTable
extends Attribute
implements InstructionPtr {
    private List _locals = new ArrayList();

    LocalVariableTable(int n, Attributes attributes) {
        super(n, attributes);
    }

    public LocalVariable[] getLocalVariables() {
        return this._locals.toArray(new LocalVariable[this._locals.size()]);
    }

    public LocalVariable getLocalVariable(int n) {
        for (int i = 0; i < this._locals.size(); ++i) {
            if (((LocalVariable)this._locals.get(i)).getLocal() != n) continue;
            return (LocalVariable)this._locals.get(i);
        }
        return null;
    }

    public LocalVariable getLocalVariable(String string) {
        for (int i = 0; i < this._locals.size(); ++i) {
            String string2 = ((LocalVariable)this._locals.get(i)).getName();
            if ((string2 != null || string != null) && (string2 == null || !string2.equals(string))) continue;
            return (LocalVariable)this._locals.get(i);
        }
        return null;
    }

    public LocalVariable[] getLocalVariables(String string) {
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < this._locals.size(); ++i) {
            String string2 = ((LocalVariable)this._locals.get(i)).getName();
            if ((string2 != null || string != null) && (string2 == null || !string2.equals(string))) continue;
            linkedList.add(this._locals.get(i));
        }
        return linkedList.toArray(new LocalVariable[linkedList.size()]);
    }

    public void setLocalVariables(LocalVariable[] localVariableArray) {
        this.clear();
        if (localVariableArray != null) {
            for (int i = 0; i < localVariableArray.length; ++i) {
                this.addLocalVariable(localVariableArray[i]);
            }
        }
    }

    public LocalVariable addLocalVariable(LocalVariable localVariable) {
        LocalVariable localVariable2 = this.addLocalVariable(localVariable.getName(), localVariable.getTypeName());
        localVariable2.setStartPc(localVariable.getStartPc());
        localVariable2.setLength(localVariable.getLength());
        return localVariable2;
    }

    public LocalVariable addLocalVariable() {
        LocalVariable localVariable = new LocalVariable(this);
        this._locals.add(localVariable);
        return localVariable;
    }

    public LocalVariable addLocalVariable(String string, String string2) {
        LocalVariable localVariable = this.addLocalVariable();
        localVariable.setName(string);
        localVariable.setType(string2);
        return localVariable;
    }

    public LocalVariable addLocalVariable(String string, Class clazz) {
        String string2 = clazz == null ? null : clazz.getName();
        return this.addLocalVariable(string, string2);
    }

    public LocalVariable addLocalVariable(String string, BCClass bCClass) {
        String string2 = bCClass == null ? null : bCClass.getName();
        return this.addLocalVariable(string, string2);
    }

    public void clear() {
        for (int i = 0; i < this._locals.size(); ++i) {
            ((LocalVariable)this._locals.get(i)).invalidate();
        }
        this._locals.clear();
    }

    public boolean removeLocalVariable(int n) {
        return this.removeLocalVariable(this.getLocalVariable(n));
    }

    public boolean removeLocalVariable(String string) {
        return this.removeLocalVariable(this.getLocalVariable(string));
    }

    public boolean removeLocalVariable(LocalVariable localVariable) {
        if (localVariable == null || !this._locals.remove(localVariable)) {
            return false;
        }
        localVariable.invalidate();
        return true;
    }

    public void updateTargets() {
        for (int i = 0; i < this._locals.size(); ++i) {
            ((LocalVariable)this._locals.get(i)).updateTargets();
        }
    }

    public void replaceTarget(Instruction instruction, Instruction instruction2) {
        for (int i = 0; i < this._locals.size(); ++i) {
            ((LocalVariable)this._locals.get(i)).replaceTarget(instruction, instruction2);
        }
    }

    public Code getCode() {
        return (Code)this.getOwner();
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterLocalVariableTable(this);
        LocalVariable[] localVariableArray = this.getLocalVariables();
        for (int i = 0; i < localVariableArray.length; ++i) {
            localVariableArray[i].acceptVisit(bCVisitor);
        }
        bCVisitor.exitLocalVariableTable(this);
    }

    int getLength() {
        return 2 + 10 * this._locals.size();
    }

    void read(Attribute attribute) {
        this.setLocalVariables(((LocalVariableTable)attribute).getLocalVariables());
    }

    void read(DataInput dataInput, int n) throws IOException {
        this.clear();
        int n2 = dataInput.readUnsignedShort();
        for (int i = 0; i < n2; ++i) {
            LocalVariable localVariable = this.addLocalVariable();
            localVariable.read(dataInput);
        }
    }

    void write(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeShort(this._locals.size());
        for (int i = 0; i < this._locals.size(); ++i) {
            ((LocalVariable)this._locals.get(i)).write(dataOutput);
        }
    }
}

