/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode.lowlevel;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.visitor.BCVisitor;
import serp.util.Numbers;

public class LongEntry
extends Entry
implements ConstantEntry {
    private long _value = 0L;

    public LongEntry() {
    }

    public LongEntry(long l) {
        this._value = l;
    }

    public boolean isWide() {
        return true;
    }

    public int getType() {
        return 5;
    }

    public long getValue() {
        return this._value;
    }

    public void setValue(long l) {
        Object object = this.beforeModify();
        this._value = l;
        this.afterModify(object);
    }

    public Object getConstant() {
        return Numbers.valueOf(this.getValue());
    }

    public void setConstant(Object object) {
        this.setValue(((Number)object).longValue());
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterLongEntry(this);
        bCVisitor.exitLongEntry(this);
    }

    void readData(DataInput dataInput) throws IOException {
        this._value = dataInput.readLong();
    }

    void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this._value);
    }
}

