/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode.lowlevel;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.Entry;
import serp.bytecode.visitor.BCVisitor;

public class FloatEntry
extends Entry
implements ConstantEntry {
    private float _value = 0.0f;

    public FloatEntry() {
    }

    public FloatEntry(float f) {
        this._value = f;
    }

    public int getType() {
        return 4;
    }

    public float getValue() {
        return this._value;
    }

    public void setValue(float f) {
        Object object = this.beforeModify();
        this._value = f;
        this.afterModify(object);
    }

    public Object getConstant() {
        return new Float(this.getValue());
    }

    public void setConstant(Object object) {
        this.setValue(((Number)object).floatValue());
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterFloatEntry(this);
        bCVisitor.exitFloatEntry(this);
    }

    void readData(DataInput dataInput) throws IOException {
        this._value = dataInput.readFloat();
    }

    void writeData(DataOutput dataOutput) throws IOException {
        dataOutput.writeFloat(this._value);
    }
}

