/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.LocalVariableInstruction;
import serp.bytecode.visitor.BCVisitor;

public class RetInstruction
extends LocalVariableInstruction {
    RetInstruction(Code code) {
        super(code, 169);
    }

    int getLength() {
        return super.getLength() + 1;
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (this == instruction) {
            return true;
        }
        if (!(instruction instanceof RetInstruction)) {
            return false;
        }
        return super.equalsInstruction(instruction);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterRetInstruction(this);
        bCVisitor.exitRetInstruction(this);
    }

    void read(DataInput dataInput) throws IOException {
        super.read(dataInput);
        this.setLocal(dataInput.readUnsignedByte());
    }

    void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeByte(this.getLocal());
    }
}

