/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.BCClass;
import serp.bytecode.BCEntity;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtr;
import serp.bytecode.InstructionPtrStrategy;
import serp.bytecode.LocalVariableTable;
import serp.bytecode.Project;
import serp.bytecode.lowlevel.ConstantPool;
import serp.bytecode.lowlevel.UTF8Entry;
import serp.bytecode.visitor.BCVisitor;
import serp.util.Strings;

public class LocalVariable
implements BCEntity,
InstructionPtr {
    private InstructionPtrStrategy _target = new InstructionPtrStrategy(this);
    private LocalVariableTable _owner = null;
    private int _length = 0;
    private int _nameIndex = 0;
    private int _descriptorIndex = 0;
    private int _index = 0;

    LocalVariable(LocalVariableTable localVariableTable) {
        this._owner = localVariableTable;
    }

    public LocalVariableTable getTable() {
        return this._owner;
    }

    void invalidate() {
        this._owner = null;
    }

    public int getLocal() {
        return this._index;
    }

    public void setLocal(int n) {
        this._index = n;
    }

    public int getParam() {
        return this.getCode().getParamsIndex(this.getLocal());
    }

    public void setParam(int n) {
        this.setLocal(this.getTable().getCode().getLocalsIndex(n));
    }

    public int getStartPc() {
        return this._target.getByteIndex();
    }

    public Instruction getStart() {
        return this._target.getTargetInstruction();
    }

    public void setStartPc(int n) {
        this._target.setByteIndex(n);
    }

    public void setStart(Instruction instruction) {
        this._target.setTargetInstruction(instruction);
    }

    public void updateTargets() {
        this._target.updateTargets();
    }

    public void replaceTarget(Instruction instruction, Instruction instruction2) {
        this._target.replaceTarget(instruction, instruction2);
    }

    public int getLength() {
        return this._length;
    }

    public void setLength(int n) {
        this._length = n;
    }

    public int getNameIndex() {
        return this._nameIndex;
    }

    public void setNameIndex(int n) {
        this._nameIndex = n;
    }

    public String getName() {
        if (this.getNameIndex() == 0) {
            return null;
        }
        return ((UTF8Entry)this.getPool().getEntry(this.getNameIndex())).getValue();
    }

    public void setName(String string) {
        if (string == null) {
            this.setNameIndex(0);
        } else {
            this.setNameIndex(this.getPool().findUTF8Entry(string, true));
        }
    }

    public int getTypeIndex() {
        return this._descriptorIndex;
    }

    public void setTypeIndex(int n) {
        this._descriptorIndex = n;
    }

    public String getTypeName() {
        if (this.getTypeIndex() == 0) {
            return null;
        }
        UTF8Entry uTF8Entry = (UTF8Entry)this.getPool().getEntry(this.getTypeIndex());
        return this.getProject().getNameCache().getExternalForm(uTF8Entry.getValue(), false);
    }

    public Class getType() {
        String string = this.getTypeName();
        if (string == null) {
            return null;
        }
        return Strings.toClass(string, this.getClassLoader());
    }

    public BCClass getTypeBC() {
        String string = this.getTypeName();
        if (string == null) {
            return null;
        }
        return this.getProject().loadClass(string, this.getClassLoader());
    }

    public void setType(String string) {
        if (string == null) {
            this.setTypeIndex(0);
        } else {
            string = this.getProject().getNameCache().getInternalForm(string, true);
            this.setTypeIndex(this.getPool().findUTF8Entry(string, true));
        }
    }

    public void setType(Class clazz) {
        if (clazz == null) {
            this.setType((String)null);
        } else {
            this.setType(clazz.getName());
        }
    }

    public void setType(BCClass bCClass) {
        if (bCClass == null) {
            this.setType((String)null);
        } else {
            this.setType(bCClass.getName());
        }
    }

    public Project getProject() {
        return this._owner.getProject();
    }

    public ConstantPool getPool() {
        return this._owner.getPool();
    }

    public ClassLoader getClassLoader() {
        return this._owner.getClassLoader();
    }

    public boolean isValid() {
        return this._owner != null;
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterLocalVariable(this);
        bCVisitor.exitLocalVariable(this);
    }

    void read(DataInput dataInput) throws IOException {
        this.setStartPc(dataInput.readUnsignedShort());
        this.setLength(dataInput.readUnsignedShort());
        this.setNameIndex(dataInput.readUnsignedShort());
        this.setTypeIndex(dataInput.readUnsignedShort());
        this.setLocal(dataInput.readUnsignedShort());
    }

    void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.getStartPc());
        dataOutput.writeShort(this.getLength());
        dataOutput.writeShort(this.getNameIndex());
        dataOutput.writeShort(this.getTypeIndex());
        dataOutput.writeShort(this.getLocal());
    }

    public Code getCode() {
        return this.getTable().getCode();
    }
}

