/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtr;
import serp.bytecode.InstructionPtrStrategy;
import serp.bytecode.TypedInstruction;
import serp.bytecode.visitor.BCVisitor;

public class JumpInstruction
extends TypedInstruction
implements InstructionPtr {
    private InstructionPtrStrategy _target = new InstructionPtrStrategy(this);

    JumpInstruction(Code code, int n) {
        super(code, n);
    }

    public int getLogicalStackChange() {
        return this.getStackChange();
    }

    public int getStackChange() {
        if (this.getOpcode() == 168) {
            return 1;
        }
        return 0;
    }

    int getLength() {
        switch (this.getOpcode()) {
            case 200: 
            case 201: {
                return super.getLength() + 4;
            }
        }
        return super.getLength() + 2;
    }

    public String getTypeName() {
        return null;
    }

    public TypedInstruction setType(String string) {
        throw new UnsupportedOperationException();
    }

    public Instruction getTarget() {
        return this._target.getTargetInstruction();
    }

    public JumpInstruction setTarget(Instruction instruction) {
        this._target.setTargetInstruction(instruction);
        return this;
    }

    public boolean equalsInstruction(Instruction instruction) {
        if (this == instruction) {
            return true;
        }
        if (!super.equalsInstruction(instruction)) {
            return false;
        }
        Instruction instruction2 = ((JumpInstruction)instruction).getTarget();
        return instruction2 == null || this.getTarget() == null || instruction2 == this.getTarget();
    }

    public void updateTargets() {
        this._target.updateTargets();
    }

    public void replaceTarget(Instruction instruction, Instruction instruction2) {
        this._target.replaceTarget(instruction, instruction2);
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterJumpInstruction(this);
        bCVisitor.exitJumpInstruction(this);
    }

    void read(Instruction instruction) {
        super.read(instruction);
        this._target.setByteIndex(((JumpInstruction)instruction)._target.getByteIndex());
    }

    void read(DataInput dataInput) throws IOException {
        super.read(dataInput);
        switch (this.getOpcode()) {
            case 200: 
            case 201: {
                this.setOffset(dataInput.readInt());
                break;
            }
            default: {
                this.setOffset(dataInput.readShort());
            }
        }
    }

    void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        switch (this.getOpcode()) {
            case 200: 
            case 201: {
                dataOutput.writeInt(this.getOffset());
                break;
            }
            default: {
                dataOutput.writeShort(this.getOffset());
            }
        }
    }

    void calculateOpcode() {
        switch (this.getOpcode()) {
            case 167: 
            case 200: {
                int n = this.getOffset();
                if (n < 131072) {
                    this.setOpcode(167);
                    break;
                }
                this.setOpcode(200);
                break;
            }
            case 168: 
            case 201: {
                int n = this.getOffset();
                if (n < 131072) {
                    this.setOpcode(168);
                    break;
                }
                this.setOpcode(201);
            }
        }
    }

    public void setOffset(int n) {
        this._target.setByteIndex(this.getByteIndex() + n);
        this.calculateOpcode();
    }

    public int getOffset() {
        return this._target.getByteIndex() - this.getByteIndex();
    }
}

