/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtr;

class InstructionPtrStrategy
implements InstructionPtr {
    private InstructionPtr _pointer;
    private Instruction _target = null;
    private int _byteIndex = -1;

    public InstructionPtrStrategy(InstructionPtr instructionPtr) {
        this._pointer = instructionPtr;
    }

    public InstructionPtrStrategy(InstructionPtr instructionPtr, Instruction instruction) {
        this(instructionPtr);
        this.setTargetInstruction(instruction);
    }

    public void setByteIndex(int n) {
        if (n < 0 && n != -1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this._byteIndex = n;
        this._target = null;
    }

    public void setTargetInstruction(Instruction instruction) {
        if (instruction.getCode() != this.getCode()) {
            throw new IllegalArgumentException("Instruction pointers and targets must be part of the same code block.");
        }
        this._target = instruction;
        this._byteIndex = -1;
    }

    public Instruction getTargetInstruction() {
        if (this._target != null) {
            return this._target;
        }
        return this.getCode().getInstruction(this._byteIndex);
    }

    public int getByteIndex() {
        if (this._target == null) {
            return this._byteIndex;
        }
        return this._target.getByteIndex();
    }

    public void updateTargets() {
        if (this._target == null) {
            this._target = this.getCode().getInstruction(this._byteIndex);
        }
    }

    public void replaceTarget(Instruction instruction, Instruction instruction2) {
        if (this.getTargetInstruction() == instruction) {
            this.setTargetInstruction(instruction2);
        }
    }

    public Code getCode() {
        return this._pointer.getCode();
    }
}

