/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.Attribute;
import serp.bytecode.Attributes;
import serp.bytecode.BCClass;
import serp.bytecode.BCField;
import serp.bytecode.lowlevel.ConstantEntry;
import serp.bytecode.lowlevel.DoubleEntry;
import serp.bytecode.lowlevel.FloatEntry;
import serp.bytecode.lowlevel.IntEntry;
import serp.bytecode.lowlevel.LongEntry;
import serp.bytecode.lowlevel.StringEntry;
import serp.bytecode.visitor.BCVisitor;

public class ConstantValue
extends Attribute {
    int _valueIndex = 0;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;

    ConstantValue(int n, Attributes attributes) {
        super(n, attributes);
    }

    int getLength() {
        return 2;
    }

    public BCField getField() {
        return (BCField)this.getOwner();
    }

    public int getValueIndex() {
        return this._valueIndex;
    }

    public void setValueIndex(int n) {
        this._valueIndex = n;
    }

    public String getTypeName() {
        Class clazz = this.getType();
        if (clazz == null) {
            return null;
        }
        return clazz.getName();
    }

    public Class getType() {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ConstantValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Integer.TYPE;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ConstantValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Float.TYPE;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ConstantValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Double.TYPE;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ConstantValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Long.TYPE;
        }
        return class$java$lang$String == null ? (class$java$lang$String = ConstantValue.class$("java.lang.String")) : class$java$lang$String;
    }

    public BCClass getTypeBC() {
        return this.getProject().loadClass(this.getType());
    }

    public Object getValue() {
        if (this._valueIndex <= 0) {
            return null;
        }
        return ((ConstantEntry)((Object)this.getPool().getEntry(this._valueIndex))).getConstant();
    }

    public void setValue(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConstantValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            this.setIntValue((Boolean)object != false ? 1 : 0);
        } else if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = ConstantValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            this.setIntValue(((Character)object).charValue());
        } else if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = ConstantValue.class$("java.lang.Byte")) : class$java$lang$Byte) || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = ConstantValue.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = ConstantValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            this.setIntValue(((Number)object).intValue());
        } else if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = ConstantValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            this.setFloatValue(((Number)object).floatValue());
        } else if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = ConstantValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            this.setDoubleValue(((Number)object).doubleValue());
        } else if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = ConstantValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            this.setLongValue(((Number)object).longValue());
        } else {
            this.setStringValue(object.toString());
        }
    }

    public int getIntValue() {
        if (this.getValueIndex() <= 0) {
            return 0;
        }
        return ((IntEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setIntValue(int n) {
        this.setValueIndex(this.getPool().findIntEntry(n, true));
    }

    public float getFloatValue() {
        if (this.getValueIndex() <= 0) {
            return 0.0f;
        }
        return ((FloatEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setFloatValue(float f) {
        this.setValueIndex(this.getPool().findFloatEntry(f, true));
    }

    public double getDoubleValue() {
        if (this.getValueIndex() <= 0) {
            return 0.0;
        }
        return ((DoubleEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setDoubleValue(double d) {
        this.setValueIndex(this.getPool().findDoubleEntry(d, true));
    }

    public long getLongValue() {
        if (this.getValueIndex() <= 0) {
            return 0L;
        }
        return ((LongEntry)this.getPool().getEntry(this.getValueIndex())).getValue();
    }

    public void setLongValue(long l) {
        this.setValueIndex(this.getPool().findLongEntry(l, true));
    }

    public String getStringValue() {
        if (this.getValueIndex() <= 0) {
            return null;
        }
        return ((StringEntry)this.getPool().getEntry(this.getValueIndex())).getStringEntry().getValue();
    }

    public void setStringValue(String string) {
        this.setValueIndex(this.getPool().findStringEntry(string, true));
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterConstantValue(this);
        bCVisitor.exitConstantValue(this);
    }

    void read(Attribute attribute) {
        this.setValue(((ConstantValue)attribute).getValue());
    }

    void read(DataInput dataInput, int n) throws IOException {
        this.setValueIndex(dataInput.readUnsignedShort());
    }

    void write(DataOutput dataOutput, int n) throws IOException {
        dataOutput.writeShort(this.getValueIndex());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

