/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import serp.bytecode.BCClass;
import serp.bytecode.BCMember;
import serp.bytecode.Code;
import serp.bytecode.Exceptions;
import serp.bytecode.visitor.BCVisitor;
import serp.bytecode.visitor.VisitAcceptor;
import serp.util.Strings;

public class BCMethod
extends BCMember
implements VisitAcceptor {
    BCMethod(BCClass bCClass) {
        super(bCClass);
    }

    public boolean isSynchronized() {
        return (this.getAccessFlags() & 0x20) > 0;
    }

    public void setSynchronized(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x20);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFFDF);
        }
    }

    public boolean isNative() {
        return (this.getAccessFlags() & 0x100) > 0;
    }

    public void setNative(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x100);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFEFF);
        }
    }

    public boolean isAbstract() {
        return (this.getAccessFlags() & 0x400) > 0;
    }

    public void setAbstract(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x400);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFFBFF);
        }
    }

    public boolean isStrict() {
        return (this.getAccessFlags() & 0x800) > 0;
    }

    public void setStrict(boolean bl) {
        if (bl) {
            this.setAccessFlags(this.getAccessFlags() | 0x800);
        } else {
            this.setAccessFlags(this.getAccessFlags() & 0xFFFFF7FF);
        }
    }

    public String getReturnName() {
        return this.getProject().getNameCache().getExternalForm(this.getProject().getNameCache().getDescriptorReturnName(this.getDescriptor()), false);
    }

    public Class getReturnType() {
        return Strings.toClass(this.getReturnName(), this.getClassLoader());
    }

    public BCClass getReturnBC() {
        return this.getProject().loadClass(this.getReturnName(), this.getClassLoader());
    }

    public void setReturn(String string) {
        this.setDescriptor(this.getProject().getNameCache().getDescriptor(string, this.getParamNames()));
    }

    public void setReturn(Class clazz) {
        this.setReturn(clazz.getName());
    }

    public void setReturn(BCClass bCClass) {
        this.setReturn(bCClass.getName());
    }

    public String[] getParamNames() {
        String[] stringArray = this.getProject().getNameCache().getDescriptorParamNames(this.getDescriptor());
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.getProject().getNameCache().getExternalForm(stringArray[i], false);
        }
        return stringArray;
    }

    public Class[] getParamTypes() {
        String[] stringArray = this.getParamNames();
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Strings.toClass(stringArray[i], this.getClassLoader());
        }
        return classArray;
    }

    public BCClass[] getParamBCs() {
        String[] stringArray = this.getParamNames();
        BCClass[] bCClassArray = new BCClass[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            bCClassArray[i] = this.getProject().loadClass(stringArray[i], this.getClassLoader());
        }
        return bCClassArray;
    }

    public void setParams(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.setDescriptor(this.getProject().getNameCache().getDescriptor(this.getReturnName(), stringArray));
    }

    public void setParams(Class[] classArray) {
        if (classArray == null) {
            this.setParams((String[])null);
        }
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        this.setParams(stringArray);
    }

    public void setParams(BCClass[] bCClassArray) {
        if (bCClassArray == null) {
            this.setParams((String[])null);
        }
        String[] stringArray = new String[bCClassArray.length];
        for (int i = 0; i < bCClassArray.length; ++i) {
            stringArray[i] = bCClassArray[i].getName();
        }
        this.setParams(stringArray);
    }

    public void addParam(String string) {
        String[] stringArray = this.getParamNames();
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = string;
        this.setParams(stringArray2);
    }

    public void addParam(Class clazz) {
        this.addParam(clazz.getName());
    }

    public void addParam(BCClass bCClass) {
        this.addParam(bCClass.getName());
    }

    public void addParam(int n, String string) {
        String[] stringArray = this.getParamNames();
        if (n < 0 || n >= stringArray.length) {
            throw new IndexOutOfBoundsException("pos = " + n);
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        int n2 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i == n ? string : stringArray[n2++];
        }
        this.setParams(stringArray2);
    }

    public void addParam(int n, Class clazz) {
        this.addParam(n, clazz.getName());
    }

    public void addParam(int n, BCClass bCClass) {
        this.addParam(n, bCClass.getName());
    }

    public void setParam(int n, String string) {
        String[] stringArray = this.getParamNames();
        if (n < 0 || n >= stringArray.length) {
            throw new IndexOutOfBoundsException("pos = " + n);
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i == n ? string : stringArray[i];
        }
        this.setParams(stringArray2);
    }

    public void setParam(int n, Class clazz) {
        this.setParam(n, clazz.getName());
    }

    public void setParam(int n, BCClass bCClass) {
        this.setParam(n, bCClass.getName());
    }

    public void clearParams() {
        this.setParams((String[])null);
    }

    public void removeParam(int n) {
        String[] stringArray = this.getParamNames();
        if (n < 0 || n >= stringArray.length) {
            throw new IndexOutOfBoundsException("pos = " + n);
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == n) continue;
            stringArray2[n2++] = stringArray[i];
        }
        this.setParams(stringArray2);
    }

    public Exceptions getExceptions(boolean bl) {
        Exceptions exceptions = (Exceptions)this.getAttribute("Exceptions");
        if (!bl || exceptions != null) {
            return exceptions;
        }
        if (exceptions == null) {
            exceptions = (Exceptions)this.addAttribute("Exceptions");
        }
        return exceptions;
    }

    public boolean removeExceptions() {
        return this.removeAttribute("Exceptions");
    }

    public Code getCode(boolean bl) {
        Code code = (Code)this.getAttribute("Code");
        if (code != null) {
            code.beforeFirst();
            return code;
        }
        if (!bl) {
            return null;
        }
        return (Code)this.addAttribute("Code");
    }

    public boolean removeCode() {
        return this.removeAttribute("Code");
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterBCMethod(this);
        this.visitAttributes(bCVisitor);
        bCVisitor.exitBCMethod(this);
    }

    void initialize(String string, String string2) {
        super.initialize(string, string2);
        this.makePublic();
    }
}

