/*
 * Decompiled with CFR 0.152.
 */
package enforcer.instr;

import enforcer.etc.Options;
import enforcer.log.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import serp.bytecode.BCClass;
import serp.bytecode.BCMethod;
import serp.bytecode.ClassInstruction;
import serp.bytecode.Code;
import serp.bytecode.ConstantInstruction;
import serp.bytecode.ExceptionHandler;
import serp.bytecode.Exceptions;
import serp.bytecode.IfInstruction;
import serp.bytecode.Instruction;
import serp.bytecode.JumpInstruction;
import serp.bytecode.LocalVariable;
import serp.bytecode.LocalVariableInstruction;
import serp.bytecode.LocalVariableTable;
import serp.bytecode.MethodInstruction;
import serp.bytecode.Project;
import serp.bytecode.StackInstruction;

public class CoverageTransformer {
    public static final String ENFORCER_EXC_MSG = "Artificial exception generated for coverage";
    static final String NEW_TEST_SUPER_CLASS = "enforcer.rt.ExceptionTestCase";
    public static int excBlock = 0;
    private LocalVariable excBlockLocalVar;
    private LocalVariable invocationTarget;
    private LocalVariable dynCheckResult;
    BCMethod currentMethod;
    TreeSet<InstrSetEntry> instrSet;
    HashSet<Instruction> handlerSet;
    boolean dynExcCheck = Options.getBool("dynExcCheck");

    Constructor getExcCons(Class clazz) {
        Class[] classArray = new Class[]{String.class};
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class[] classArray2 = new Class[]{String.class, Throwable.class};
            try {
                return clazz.getConstructor(classArray2);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                Class[] classArray3 = new Class[]{Throwable.class, String.class};
                try {
                    return clazz.getConstructor(classArray3);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    return null;
                }
            }
        }
    }

    private void addArg(boolean bl, Code code, String[] stringArray, int n) {
        ConstantInstruction constantInstruction = code.constant();
        if (bl) {
            stringArray[n] = "Ljava/lang/String;";
            constantInstruction.setValue(ENFORCER_EXC_MSG);
        } else {
            code.constant().setNull();
            stringArray[n] = "Ljava/lang/Throwable;";
        }
    }

    boolean addExcCheck(Instruction instruction) {
        if (instruction.getOpcode() == 184 || instruction.getOpcode() == 183) {
            return false;
        }
        return this.dynExcCheck;
    }

    Instruction findInstanceCalled(Instruction instruction, Code code) {
        MethodInstruction methodInstruction = (MethodInstruction)instruction;
        for (int i = methodInstruction.getMethodParamTypes().length; i != 0; i -= instruction.getStackChange()) {
            instruction = code.previous();
        }
        code.before(instruction);
        StackInstruction stackInstruction = code.dup();
        if (this.invocationTarget == null) {
            this.invocationTarget = CoverageTransformer.addLocalVar(code, "$invocationTarget", "Ljava/lang/Object;");
        }
        code.astore().setLocalVariable(this.invocationTarget);
        return stackInstruction;
    }

    Instruction addDynamicExcTypeCheck(Code code, Instruction instruction, Class clazz) {
        BCMethod bCMethod = ((MethodInstruction)instruction).getMethod();
        if (this.dynCheckResult == null) {
            this.dynCheckResult = CoverageTransformer.addLocalVar(code, "$dynCheckResult", "Z");
        }
        if (bCMethod == null) {
            BCMethod bCMethod2 = (BCMethod)code.getOwner();
            Log.log(bCMethod2.getDeclarer().getName() + "." + bCMethod2.getName() + ": Cannot obtain method descriptor for " + ((MethodInstruction)instruction).getMethodName(), 1);
            ConstantInstruction constantInstruction = code.constant().setValue(0);
            code.istore().setLocalVariable(this.dynCheckResult);
            return constantInstruction;
        }
        LocalVariableInstruction localVariableInstruction = code.aload().setLocalVariable(this.invocationTarget);
        code.invokevirtual().setMethod("java/lang/Object", "getClass", "Ljava/lang/Class;", new String[0]);
        code.constant().setValue(bCMethod.getName());
        String[] stringArray = bCMethod.getParamNames();
        code.constant().setValue(stringArray.length);
        code.anewarray().setType("Ljava/lang/Class;");
        String[] stringArray2 = new String[]{"Ljava/lang/String;"};
        for (int i = 0; i < stringArray.length; ++i) {
            code.dup();
            code.constant().setValue(i);
            code.constant().setValue(stringArray[i]);
            code.invokestatic().setMethod("enforcer/rt/Reflect", "getClsDesc", "Ljava/lang/Class;", stringArray2);
            code.aastore();
        }
        String[] stringArray3 = new String[]{"Ljava/lang/String;", "[Ljava/lang/Class;"};
        MethodInstruction methodInstruction = code.invokevirtual();
        methodInstruction.setMethod("java/lang/Class", "getDeclaredMethod", "Ljava/lang/reflect/Method;", stringArray3);
        JumpInstruction jumpInstruction = code.go2();
        StackInstruction stackInstruction = code.dup();
        code.invokevirtual().setMethod("java/lang/NoSuchMethodException", "printStackTrace", "V", new String[0]);
        code.athrow();
        code.addExceptionHandler((Instruction)methodInstruction, (Instruction)jumpInstruction, (Instruction)stackInstruction, "java/lang/NoSuchMethodException");
        jumpInstruction.setTarget((Instruction)code.constant().setValue(clazz.getName()));
        code.constant().setValue(excBlock);
        String[] stringArray4 = new String[]{"Ljava/lang/reflect/Method;", "Ljava/lang/String;", "I"};
        code.invokestatic().setMethod("enforcer/rt/Reflect", "checkMethodExc", "Z", stringArray4);
        code.istore().setLocalVariable(this.dynCheckResult);
        return localVariableInstruction;
    }

    void addExcLauncher(Code code, InstrSetEntry instrSetEntry, boolean bl) {
        Instruction instruction = instrSetEntry.ins;
        Class clazz = instrSetEntry.excType;
        Constructor constructor = instrSetEntry.excCons;
        Instruction instruction2 = null;
        String string = code.getMethod().getDeclarer().getName();
        code.before(instruction);
        if (this.addExcCheck(instruction)) {
            instruction2 = this.findInstanceCalled(instruction, code);
        }
        if (instruction2 != null) {
            instruction2 = code.constant().setValue(excBlock);
        } else {
            code.constant().setValue(excBlock);
        }
        code.istore().setLocalVariable(this.excBlockLocalVar);
        code.getstatic().setField("enforcer.rt.Eval", "reRun", "I");
        code.constant().setValue(excBlock);
        IfInstruction ifInstruction = code.ificmpeq();
        code.getstatic().setField("enforcer.rt.Eval", "excPath", "I");
        code.constant().setValue(excBlock);
        IfInstruction ifInstruction2 = code.ificmpne();
        ClassInstruction classInstruction = code.anew();
        classInstruction.setType(clazz.getName());
        code.dup();
        Class<?>[] classArray = constructor.getParameterTypes();
        int n = classArray.length;
        String[] stringArray = new String[n];
        this.addArg(classArray[0] == String.class, code, stringArray, 0);
        if (n == 2) {
            this.addArg(classArray[1] == String.class, code, stringArray, 1);
        }
        MethodInstruction methodInstruction = code.invokespecial();
        methodInstruction.setMethod(clazz.getName(), "<init>", "V", stringArray);
        code.athrow();
        Instruction instruction3 = instruction;
        if (this.addExcCheck(instruction)) {
            instruction3 = this.addDynamicExcTypeCheck(code, instruction, clazz);
        }
        ifInstruction.setTarget((Instruction)classInstruction);
        if (bl) {
            ifInstruction2.setTarget(code.nop());
        } else {
            ifInstruction2.setTarget(instruction3);
        }
    }

    void recordTest(Instruction instruction) {
        IfInstruction ifInstruction = null;
        Code code = instruction.getCode();
        code.after(instruction);
        if (this.addExcCheck(instruction)) {
            code.iload().setLocalVariable(this.dynCheckResult);
            ifInstruction = code.ifne();
        }
        ConstantInstruction constantInstruction = code.constant();
        constantInstruction.setValue(excBlock);
        MethodInstruction methodInstruction = code.invokestatic();
        String[] stringArray = new String[]{"I"};
        methodInstruction.setMethod("enforcer.rt.Coverage", "recordTest", "V", stringArray);
        if (this.addExcCheck(instruction)) {
            ifInstruction.setTarget(code.next());
        }
    }

    void fixGoto(Code code, Instruction instruction) {
        Instruction instruction2 = code.next();
        Instruction[] instructionArray = code.getInstructions();
        for (int i = 0; i < instructionArray.length; ++i) {
            if (!(instructionArray[i] instanceof JumpInstruction) || ((JumpInstruction)instructionArray[i]).getTarget() != instruction2) continue;
            Log.log("Adjusting target for instr. " + instructionArray[i].getByteIndex() + " from " + instruction2.getByteIndex() + " to " + instruction.getByteIndex());
            ((JumpInstruction)instructionArray[i]).setTarget(instruction);
        }
    }

    void instrumentHandler(Code code, Instruction instruction) {
        code.after(instruction);
        code.getstatic().setField("enforcer.rt.Coverage", "exc", "Ljava/util/BitSet;");
        code.iload().setLocalVariable(this.excBlockLocalVar);
        String[] stringArray = new String[]{"I"};
        MethodInstruction methodInstruction = code.invokevirtual();
        methodInstruction.setMethod("java.util.BitSet", "set", "V", stringArray);
    }

    void instrumentHandlers(Code code) {
        Iterator<Instruction> iterator = this.handlerSet.iterator();
        while (iterator.hasNext()) {
            this.instrumentHandler(code, iterator.next());
        }
    }

    boolean checkInvocationArg(MethodInstruction methodInstruction) {
        if (methodInstruction.getMethodName().compareTo("run") != 0) {
            return false;
        }
        String string = methodInstruction.getMethodDeclarerName();
        if (!string.startsWith("junit.") || !string.endsWith(".TestRunner")) {
            return false;
        }
        String string2 = methodInstruction.getMethodReturnName();
        String[] stringArray = methodInstruction.getMethodParamNames();
        String[] stringArray2 = new String[1];
        if (string2.compareTo("junit.framework.TestResult") == 0 && stringArray.length == 1 && stringArray[0].compareTo("junit.framework.Test") == 0) {
            methodInstruction.setMethod("enforcer.rt.WrappedRunner", "run", string2, stringArray);
            return true;
        }
        if (string2.compareTo("void") == 0 && stringArray.length == 1 && stringArray[0].compareTo("java.lang.Class") == 0) {
            methodInstruction.setMethod("enforcer.rt.WrappedRunner", "run", string2, stringArray);
            return true;
        }
        return false;
    }

    boolean transformTestLaunch(Code code) {
        Instruction[] instructionArray = code.getInstructions();
        boolean bl = false;
        for (int i = 0; i < instructionArray.length; ++i) {
            if (instructionArray[i].getOpcode() != 184) continue;
            MethodInstruction methodInstruction = (MethodInstruction)instructionArray[i];
            String string = methodInstruction.getMethodDeclarerName();
            if (!this.checkInvocationArg(methodInstruction)) continue;
            Log.log("Found test launch insn!");
            code.before((Instruction)methodInstruction);
            code.constant().setValue(string);
            MethodInstruction methodInstruction2 = code.invokestatic();
            String[] stringArray = new String[]{"Ljava/lang/String;"};
            methodInstruction2.setMethod("enforcer.rt.Eval", "setTestRunner", "V", stringArray);
            methodInstruction2 = code.invokestatic();
            String[] stringArray2 = new String[]{};
            methodInstruction2.setMethod("enforcer.rt.Coverage", "initialize", "V", stringArray2);
            code.after((Instruction)methodInstruction);
            methodInstruction2 = code.invokestatic();
            methodInstruction2.setMethod("enforcer.rt.Eval", "reRunTests", "Z", stringArray2);
            code.ifeq().setTarget((Instruction)methodInstruction2);
            code.calculateMaxStack();
            bl = true;
            break;
        }
        return bl;
    }

    boolean checkSuppressionList(BCMethod bCMethod) {
        if (bCMethod.isSynthetic()) {
            return true;
        }
        return bCMethod.getName().compareTo("<clinit>") == 0;
    }

    Class<Class> uncheckedCastToClass_Class(Class clazz) {
        return clazz;
    }

    static boolean excIsHandledBy(Class clazz, Class clazz2) {
        return clazz2.isAssignableFrom(clazz);
    }

    boolean insAlreadyProtected(Instruction instruction, Class[] classArray, ExceptionHandler[] exceptionHandlerArray, int n) {
        int n2 = instruction.getByteIndex();
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                ExceptionHandler exceptionHandler = exceptionHandlerArray[j];
                Class<Class> clazz2 = this.uncheckedCastToClass_Class(exceptionHandler.getCatchType());
                if (clazz2 == null || !CoverageTransformer.excIsHandledBy(clazz, clazz2) || exceptionHandler.getTryStartPc() > n2 || exceptionHandler.getTryEndPc() <= n2) continue;
                bl = true;
            }
            if (bl || !CoverageTransformer.excIsHandledBy(clazz, exceptionHandlerArray[n].getCatchType())) continue;
            Log.log("Genuine handler for " + clazz.getName() + "/" + exceptionHandlerArray[n].getCatchType().getName(), 5);
            return false;
        }
        return true;
    }

    static BCMethod getSuperClassMethod(BCClass bCClass, String string, Class[] classArray) {
        BCMethod bCMethod = null;
        for (BCClass bCClass2 = bCClass.getSuperclassBC(); bCMethod == null && bCClass2 != null; bCClass2 = bCClass2.getSuperclassBC()) {
            bCMethod = bCClass2.getDeclaredMethod(string, classArray);
        }
        if (bCMethod == null) {
            BCClass[] bCClassArray = bCClass.getInterfaceBCs();
            for (int i = 0; bCMethod == null && i < bCClassArray.length; ++i) {
                bCMethod = bCClassArray[i].getDeclaredMethod(string, classArray);
                if (bCMethod != null) continue;
                bCMethod = CoverageTransformer.getSuperClassMethod(bCClassArray[i], string, classArray);
            }
        }
        return bCMethod;
    }

    boolean checkExceptionsInIns(Instruction instruction, ExceptionHandler[] exceptionHandlerArray, int n, Constructor constructor) {
        if (!(instruction instanceof MethodInstruction)) {
            return false;
        }
        Class<Class> clazz = this.uncheckedCastToClass_Class(exceptionHandlerArray[n].getCatchType());
        MethodInstruction methodInstruction = (MethodInstruction)instruction;
        BCMethod bCMethod = methodInstruction.getMethod();
        if (bCMethod == null) {
            bCMethod = CoverageTransformer.getSuperClassMethod(methodInstruction.getMethodDeclarerBC(), methodInstruction.getMethodName(), methodInstruction.getMethodParamTypes());
        }
        if (bCMethod == null) {
            Log.log(instruction.getByteIndex() + ": " + instruction.getName() + " " + instruction.getCode().getMethod().getDeclarer().getName() + "." + instruction.getCode().getMethod().getName() + ": Could not resolve exceptions for method " + ((MethodInstruction)instruction).getMethodDeclarerName() + "." + ((MethodInstruction)instruction).getMethodName() + "; assuming " + clazz.getName() + ".", 2);
            this.addToInstrSet(instruction, clazz, constructor, n);
            this.handlerSet.add(exceptionHandlerArray[n].getHandlerStart());
            return true;
        }
        Exceptions exceptions = bCMethod.getExceptions(false);
        if (exceptions == null) {
            return false;
        }
        Class[] classArray = exceptions.getExceptionTypes();
        if (this.insAlreadyProtected(instruction, classArray, exceptionHandlerArray, n)) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (!CoverageTransformer.excIsHandledBy(classArray[i], clazz)) continue;
            Log.log(instruction.getByteIndex() + ": " + instruction.getName() + " " + ((MethodInstruction)instruction).getMethodDeclarerName() + "." + ((MethodInstruction)instruction).getMethodName() + " throws " + classArray[i].getName(), 5);
            this.addToInstrSet(instruction, classArray[i], constructor, n);
            this.handlerSet.add(exceptionHandlerArray[n].getHandlerStart());
            return true;
        }
        return false;
    }

    void instrumentThrowableIns(Code code) {
        Iterator<InstrSetEntry> iterator = this.instrSet.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        InstrSetEntry instrSetEntry = iterator.next();
        while (iterator.hasNext()) {
            InstrSetEntry instrSetEntry2 = instrSetEntry;
            instrSetEntry = iterator.next();
            boolean bl = instrSetEntry.ins.getByteIndex() == instrSetEntry2.ins.getByteIndex();
            this.addExcLauncher(code, instrSetEntry2, bl);
            this.recordTest(instrSetEntry2.ins);
            ++excBlock;
        }
        this.addExcLauncher(code, instrSetEntry, false);
        this.recordTest(instrSetEntry.ins);
        ++excBlock;
    }

    boolean checkExceptions(Code code, ExceptionHandler[] exceptionHandlerArray, int n) {
        boolean bl = false;
        ExceptionHandler exceptionHandler = exceptionHandlerArray[n];
        Class clazz = exceptionHandler.getCatchType();
        if (clazz == null) {
            return false;
        }
        Constructor constructor = this.getExcCons(clazz);
        if (constructor == null) {
            Log.log(this.currentMethod.getDeclarer().getName() + "." + this.currentMethod.getName() + ": Skipping exception of type", 1);
            Log.log(exceptionHandler.getCatchName() + ": Cannot find proper constructor.", 1);
            return false;
        }
        Instruction instruction = exceptionHandler.getTryEnd();
        code.before(exceptionHandler.getTryStart());
        Instruction instruction2 = code.next();
        while (instruction2 != instruction) {
            bl = this.checkExceptionsInIns(instruction2, exceptionHandlerArray, n, constructor) || bl;
            instruction2 = code.next();
        }
        bl = this.checkExceptionsInIns(instruction2, exceptionHandlerArray, n, constructor) || bl;
        return bl;
    }

    static LocalVariable addLocalVar(Code code, String string, String string2) {
        LocalVariableTable localVariableTable = code.getLocalVariableTable(true);
        LocalVariable localVariable = localVariableTable.addLocalVariable(string, string2);
        int n = code.getNextLocalsIndex();
        localVariable.setLocal(n);
        code.setMaxLocals(n + 1);
        localVariable.setStartPc(0);
        return localVariable;
    }

    void addExcBlockLocalVar(Code code) {
        this.excBlockLocalVar = CoverageTransformer.addLocalVar(code, "$excBlock", "I");
        code.beforeFirst();
        code.constant().setValue(-1);
        code.istore().setLocalVariable(this.excBlockLocalVar);
    }

    boolean transformHandlers(BCMethod bCMethod) {
        boolean bl = false;
        this.excBlockLocalVar = null;
        this.invocationTarget = null;
        this.dynCheckResult = null;
        this.instrSet = new TreeSet();
        this.handlerSet = new HashSet();
        Code code = bCMethod.getCode(false);
        ExceptionHandler[] exceptionHandlerArray = code.getExceptionHandlers();
        for (int i = 0; i < exceptionHandlerArray.length; ++i) {
            if (exceptionHandlerArray[i].getCatchType() == null) continue;
            Log.log("Analyzing handler for " + exceptionHandlerArray[i].getCatchType().getName() + " in " + bCMethod.getDeclarer().getName() + "." + bCMethod.getName(), 4);
            bl = this.checkExceptions(code, exceptionHandlerArray, i) || bl;
        }
        if (bl) {
            assert (this.excBlockLocalVar == null);
            this.addExcBlockLocalVar(code);
            this.instrumentThrowableIns(code);
            this.instrumentHandlers(code);
            this.excBlockLocalVar.updateTargets();
            if (this.invocationTarget != null) {
                this.invocationTarget.updateTargets();
            }
            code.calculateMaxStack();
        }
        return bl;
    }

    boolean transformPrintStackTrace(BCMethod bCMethod) {
        boolean bl = false;
        Code code = bCMethod.getCode(false);
        code.beforeFirst();
        while (code.hasNext()) {
            Instruction instruction = code.next();
            if (instruction.getOpcode() != 182) continue;
            MethodInstruction methodInstruction = (MethodInstruction)instruction;
            BCClass bCClass = methodInstruction.getMethodDeclarerBC();
            String string = methodInstruction.getMethodName();
            if (!string.equals("printStackTrace") || !CoverageTransformer.classIsException(bCClass)) continue;
            code.remove();
            methodInstruction = code.invokestatic();
            String[] stringArray = new String[]{"java.lang.Exception"};
            methodInstruction.setMethod("enforcer.rt.Reflect", "printStackTrace", "V", stringArray);
        }
        return bl;
    }

    static boolean classIsException(BCClass bCClass) {
        if (bCClass.getName().equals("java.lang.Exception")) {
            return true;
        }
        BCClass bCClass2 = bCClass.getSuperclassBC();
        if (bCClass2 != null) {
            return CoverageTransformer.classIsException(bCClass2);
        }
        return false;
    }

    boolean transformTestCaseInit(BCMethod bCMethod) {
        boolean bl = false;
        Code code = bCMethod.getCode(false);
        code.beforeFirst();
        while (code.hasNext()) {
            String string;
            MethodInstruction methodInstruction;
            Instruction instruction = code.next();
            if (instruction.getOpcode() == 183) {
                methodInstruction = (MethodInstruction)instruction;
                string = methodInstruction.getMethodDeclarerName();
                String string2 = methodInstruction.getMethodName();
                if (!string.equals("junit.framework.TestCase") || !string2.equals("<init>")) continue;
                methodInstruction.setMethodDeclarer(NEW_TEST_SUPER_CLASS);
                bl = true;
                continue;
            }
            if (instruction.getOpcode() != 187 || !(string = (methodInstruction = (ClassInstruction)instruction).getTypeName()).equals("junit.framework.TestCase")) continue;
            methodInstruction.setType(NEW_TEST_SUPER_CLASS);
            bl = true;
        }
        return bl;
    }

    boolean transformMethod(BCMethod bCMethod, boolean bl) {
        boolean bl2 = false;
        Code code = bCMethod.getCode(false);
        if (code == null) {
            return false;
        }
        if (this.checkSuppressionList(bCMethod)) {
            Log.log("Skipping method " + bCMethod.getDeclarer().getName() + "." + bCMethod.getName(), 4);
            return false;
        }
        this.currentMethod = bCMethod;
        bl2 = this.transformTestCaseInit(bCMethod) || bl2;
        boolean bl3 = bl2 = this.transformPrintStackTrace(bCMethod) || bl2;
        if (bl) {
            bl2 = this.transformHandlers(bCMethod) || bl2;
        }
        bl2 = this.transformTestLaunch(code) || bl2;
        return bl2;
    }

    public byte[] transform(BCClass bCClass) {
        byte[] byArray;
        boolean bl = false;
        boolean bl2 = true;
        String string = bCClass.getSuperclassName();
        if (string.compareTo("junit.framework.TestCase") == 0) {
            if (!Options.getBool("instrTestCode")) {
                Log.log("Will not instrument try blocks in test class " + bCClass.getName() + "...", 4);
                bl2 = false;
            }
            Log.log("Changing super class of " + bCClass.getName(), 5);
            bCClass.setSuperclass(NEW_TEST_SUPER_CLASS);
            bl = true;
        }
        BCMethod[] bCMethodArray = bCClass.getDeclaredMethods();
        for (int i = 0; i < bCMethodArray.length; ++i) {
            bl = this.transformMethod(bCMethodArray[i], bl2) || bl;
        }
        if (bl) {
            byArray = bCClass.toByteArray();
            Log.log("New class file: " + byArray.length + " bytes.");
        } else {
            byArray = null;
        }
        return byArray;
    }

    public byte[] transform(String string, byte[] byArray) {
        byte[] byArray2;
        if (string.startsWith("java/") || string.startsWith("sun/") || string.startsWith("enforcer/rt/") || string.startsWith("junit/")) {
            byArray2 = null;
        } else {
            Log.log("Transforming " + string + " (" + byArray.length + " bytes)...");
            Project project = new Project();
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                byArray2 = this.transform(new Project().loadClass((InputStream)byteArrayInputStream));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                byArray2 = null;
            }
        }
        if (byArray2 != null && Options.get("dumpPath") != null) {
            this.dumpResult(string, byArray2);
        }
        return byArray2;
    }

    void addToInstrSet(Instruction instruction, Class clazz, Constructor constructor, int n) {
        InstrSetEntry instrSetEntry = new InstrSetEntry();
        instrSetEntry.ins = instruction;
        instrSetEntry.excType = clazz;
        instrSetEntry.excCons = constructor;
        instrSetEntry.rank = n;
        assert (!this.instrSet.contains(instrSetEntry));
        this.instrSet.add(instrSetEntry);
    }

    public void dumpResult(String string, byte[] byArray) {
        try {
            String string2 = new String(Options.getString("dumpPath") + "/" + string);
            string2 = string2.substring(0, string2.lastIndexOf("/"));
            File file = new File(string2);
            file.mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(Options.getString("dumpPath") + "/" + string + ".class");
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Log.errLog("Could not open dump file: " + iOException);
        }
    }

    static class InstrSetEntry
    implements Comparable<InstrSetEntry> {
        Instruction ins;
        Class excType;
        Constructor excCons;
        int rank;

        InstrSetEntry() {
        }

        @Override
        public int compareTo(InstrSetEntry instrSetEntry) {
            int n = this.ins.getByteIndex() - instrSetEntry.ins.getByteIndex();
            if (n != 0) {
                return n;
            }
            n = this.rank - instrSetEntry.rank;
            if (n != 0) {
                return n;
            }
            return System.identityHashCode(this.excType) - System.identityHashCode(instrSetEntry.excType);
        }

        public boolean equals(Object object) {
            if (!(object instanceof InstrSetEntry)) {
                return false;
            }
            return this.compareTo((InstrSetEntry)object) == 0;
        }
    }
}

