/*
 * Decompiled with CFR 0.152.
 */
package enforcer.rt;

import enforcer.etc.Options;
import enforcer.instr.CoverageTransformer;
import enforcer.log.Log;
import enforcer.rt.Coverage;
import enforcer.rt.TestWrapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class Eval {
    static boolean dynExcCheck = Options.getBool("dynExcCheck");
    public static String testRunner = "junit.textui.TestRunner";
    public static int reRun = -1;
    public static int excPath = -1;
    static boolean newTests;
    static String currentTestMeth;
    static String currentTestCls;
    int suiteSize = 0;
    int numCatch = 0;
    int numTry = 0;
    int numUnChecked = 0;

    public static void setTestRunner(String string) {
        testRunner = string;
    }

    static TestCase getTestInstance(Class clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] classArray = new Class[]{String.class};
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            return (TestCase)constructor.newInstance(clazz.getSimpleName());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return (TestCase)constructor.newInstance(new Object[0]);
        }
    }

    void getStats(TestSuite testSuite) {
        int n = Coverage.numBlocks;
        for (int i = 0; i < n; ++i) {
            if (!Coverage.exc.get(i)) {
                Object object;
                String string;
                if (Coverage.noexcCls.size() <= i || (string = Coverage.noexcCls.get(i)) == null) {
                    if (!dynExcCheck || !Coverage.unChecked.get(i)) continue;
                    ++this.numUnChecked;
                    ++this.numTry;
                    continue;
                }
                ++this.numTry;
                TestCase testCase = null;
                try {
                    object = Class.forName(string);
                    testCase = Eval.getTestInstance(object);
                }
                catch (Exception exception) {
                    Log.errLog("Cannot find class for test " + i + ": " + string + ": " + exception);
                    continue;
                }
                ++this.suiteSize;
                if (testSuite == null) continue;
                object = Coverage.noexcMeth.get(i);
                Log.log("Adding test for method call " + i + " in " + string + "." + (String)object, 4);
                testCase.setName(Coverage.noexcMeth.get(i));
                testSuite.addTest((Test)new TestWrapper((Test)testCase, string, (String)object, i, Coverage.excPath.get(i)));
                continue;
            }
            ++this.numCatch;
            ++this.numTry;
        }
    }

    public static boolean reRunTests() {
        TestSuite testSuite = new TestSuite();
        Eval eval = new Eval();
        Log.log("*** Total number of instrumented method calls: " + CoverageTransformer.excBlock, 2);
        newTests = false;
        eval.getStats(testSuite);
        Log.log("*** Total number of executed method calls: " + eval.numTry, 2);
        Log.log("*** Total number of executed catch blocks: " + eval.numCatch, 2);
        if (dynExcCheck) {
            Log.log("*** Total number of executed method calls w/o exc.: " + eval.numUnChecked, 2);
        }
        Log.log("*** Tests with uncovered catch blocks to execute: " + eval.suiteSize, 2);
        if (eval.suiteSize == 0) {
            return true;
        }
        try {
            Class<?> clazz = Class.forName(testRunner);
            Method method = clazz.getMethod("run", Test.class);
            method.invoke(clazz, testSuite);
        }
        catch (Exception exception) {
            Log.errLog("Could not start test runner " + testRunner + ".");
        }
        if (!newTests) {
            eval = new Eval();
            eval.getStats(null);
            Log.log("*** Total number of executed method calls: " + eval.numTry, 2);
            Log.log("*** Total number of executed catch blocks: " + eval.numCatch, 2);
            if (dynExcCheck) {
                Log.log("*** Total number of executed method calls w/o exc.: " + eval.numUnChecked, 2);
            }
            Log.log("*** Tests with uncovered catch blocks to execute: " + eval.suiteSize, 2);
        }
        return !newTests;
    }
}

