/*
 * Decompiled with CFR 0.152.
 */
package enforcer.rt;

import enforcer.etc.Options;
import enforcer.log.Log;
import enforcer.rt.Coverage;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class Reflect {
    static boolean suppressArtificialException = Options.getBool("supprArtificialExc");

    public static void printStackTrace(Exception exception) {
        String string = exception.getMessage();
        if (suppressArtificialException && (string == null || string.equals("Artificial exception generated for coverage"))) {
            return;
        }
        exception.printStackTrace();
    }

    static Class clsByName(String string) {
        string = string.replace('/', '.');
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.log("Could not find class desc for " + string, 0);
            return null;
        }
    }

    public static Class getClsDesc(String string) {
        int n = string.length();
        if (n == 1) {
            switch (string.charAt(0)) {
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
            }
            assert (string.charAt(0) == 'Z');
            return Boolean.TYPE;
        }
        if (string.charAt(0) == 'L' && string.charAt(n - 1) == ';') {
            return Reflect.clsByName(string.substring(1, n - 1));
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.charAt(0) != '[') {
            return Reflect.clsByName(string);
        }
        assert (string.charAt(0) == '[');
        int n2 = string.lastIndexOf(91) + 1;
        int[] nArray = new int[n2];
        Class clazz = Reflect.getClsDesc(string.substring(n2));
        if (clazz == null) {
            return null;
        }
        Object object = Array.newInstance(clazz, nArray);
        return object.getClass();
    }

    public static boolean checkMethodExc(Method method, String string, int n) {
        Class<?>[] classArray = method.getExceptionTypes();
        Class clazz = Reflect.getClsDesc(string);
        for (int i = 0; i < classArray.length; ++i) {
            if (!clazz.isAssignableFrom(classArray[i])) continue;
            return false;
        }
        Coverage.unChecked.set(n);
        if (Coverage.numBlocks <= n) {
            Coverage.numBlocks = n + 1;
        }
        Log.log("Method " + method.getDeclaringClass().getName() + "." + method.getName() + " does not actually throw " + string, 4);
        return true;
    }
}

