/*
 * Decompiled with CFR 0.152.
 */
package enforcer;

import enforcer.etc.Options;
import enforcer.instr.CoverageTransformer;
import enforcer.log.Log;
import java.io.File;
import java.util.Iterator;
import java.util.TreeSet;
import serp.bytecode.BCClass;
import serp.bytecode.Project;

public class Main {
    public static final int OPT_DIR = 1;
    public static final int OPT_INSTR_TEST = 2;
    public static final int OPT_NO_INSTR_TEST = 3;
    public static final int OPT_LOGLEVEL = 4;
    public static final int OPT_USAGE = 5;
    public static final int OPT_SHOW = 6;
    public static boolean printUsage = false;
    public static boolean showOpts = false;
    static CoverageTransformer ct = new CoverageTransformer();

    public static final void main(String[] stringArray) {
        int n;
        try {
            for (n = 0; n < stringArray.length && stringArray[n].charAt(0) == '-'; ++n) {
                n = Main.parseOption(stringArray, n);
            }
            Main.checkValues();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Error: " + illegalArgumentException.getMessage() + ".");
            System.out.println();
            printUsage = true;
        }
        if (printUsage) {
            Main.usage();
        }
        if (showOpts) {
            if (printUsage) {
                System.out.println();
            }
            Main.showValues();
        }
        if (printUsage) {
            return;
        }
        Main.useArgs(stringArray, n);
    }

    public static void checkValues() throws IllegalArgumentException {
        if (Options.get("dumpPath") == null) {
            throw new IllegalArgumentException("Output directory (-d <outdir>) not given");
        }
    }

    public static void showValues() {
        Iterator<String> iterator = new TreeSet<String>(Options.keySet()).iterator();
        System.out.println("Key                  value");
        System.out.println("-----------------------------");
        String string = new String("                    ");
        while (iterator.hasNext()) {
            Class<?> clazz;
            String string2 = iterator.next();
            int n = string2.length();
            System.out.print(string2 + string.substring(n) + " ");
            Object object = Options.get(string2);
            Class<?> clazz2 = clazz = object != null ? object.getClass() : null;
            if (clazz == Boolean.class || clazz == Integer.class || clazz == String.class) {
                System.out.println(object);
                continue;
            }
            if (object == null) {
                System.out.println("null");
                continue;
            }
            System.out.println("non-null");
        }
    }

    public static int parseOption(String[] stringArray, int n) throws IllegalArgumentException {
        int n2;
        boolean bl;
        String string = "";
        boolean bl2 = false;
        String string2 = stringArray[n].charAt(1) == '-' ? stringArray[n].substring(2) : stringArray[n].substring(1);
        int n3 = string2.indexOf(61);
        if (n3 != -1) {
            string = string2.substring(n3 + 1);
            string2 = string2.substring(0, n3);
            bl2 = true;
        }
        if (!(bl = Main.valueRequired(n2 = Main.checkOption(string2))) && bl2) {
            throw new IllegalArgumentException("No values for option \"" + string2 + "\" supported");
        }
        if (bl && !bl2) {
            if (stringArray.length < n + 2) {
                throw new IllegalArgumentException("Missing argument for option \"" + string2 + "\"");
            }
            string = stringArray[++n];
        }
        Main.evalOption(n2, string);
        return n;
    }

    public static void evalOption(int n, String string) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                Options.set("dumpPath", string);
                break;
            }
            case 4: {
                int n2 = new Integer(string);
                if (n2 < 0 || n2 > 4) {
                    throw new IllegalArgumentException("Log level must be between 0 and 4");
                }
                Options.set("logLevel", n2);
                break;
            }
            case 3: {
                assert (string.compareTo("") == 0);
                Options.set("instrTestCode", false);
                break;
            }
            case 2: {
                assert (string.compareTo("") == 0);
                Options.set("instrTestCode", true);
                break;
            }
            case 5: {
                assert (string.compareTo("") == 0);
                printUsage = true;
                break;
            }
            default: {
                assert (string.compareTo("") == 0);
                assert (n == 6);
                showOpts = true;
            }
        }
    }

    public static int checkOption(String string) throws IllegalArgumentException {
        if (string.compareTo("d") == 0 || string.compareTo("dir") == 0) {
            return 1;
        }
        if (string.compareTo("h") == 0 || string.compareTo("help") == 0) {
            return 5;
        }
        if (string.compareTo("s") == 0 || string.compareTo("show") == 0) {
            return 6;
        }
        if (string.compareTo("instr-test") == 0) {
            return 2;
        }
        if (string.compareTo("no-instr-test") == 0) {
            return 3;
        }
        if (string.compareTo("log-level") == 0) {
            return 4;
        }
        throw new IllegalArgumentException("Option \"" + string + "\" not " + "supported.");
    }

    public static boolean valueRequired(int n) {
        switch (n) {
            case 1: 
            case 4: {
                return true;
            }
        }
        assert (n == 2 || n == 3 || n == 5 || n == 6);
        return false;
    }

    public static void usage() {
        System.out.print("Usage: ");
        System.out.print("java -jar enforcer.jar ");
        System.out.println("[-d <outdir>] [--options...] class [class...]");
        System.out.println();
        System.out.println("where options include:");
        System.out.println("-h or --help      show this screen");
        System.out.println("-s or --show      show configuration");
        System.out.println("-d <outdir>       to set output directory");
        System.out.println("                  (mandatory if ENFORCER_INSTR_DUMP not set)");
        System.out.println("--instr-test      instrument test code as well");
        System.out.println("--no-instr-test   do not instrument test code as well");
        System.out.println("--log-level <l>   set log level (0 .. 4)");
    }

    public static void useArgs(String[] stringArray, int n) {
        while (n < stringArray.length) {
            Main.transform(stringArray[n]);
            ++n;
        }
        Log.log(CoverageTransformer.excBlock + " try/catch blocks instrumented.", 2);
    }

    public static void transform(String string) {
        BCClass bCClass = new Project().loadClass(new File(string));
        byte[] byArray = ct.transform(bCClass);
        if (byArray != null) {
            String string2 = string.substring(0, string.length() - 6);
            ct.dumpResult(string2, byArray);
        }
    }
}

